{
    This file is part of Chentrah,
    Copyright (C) 2004-2008 Anton Rzheshevski (chebmaster@mail.ru).

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/

 **********************************************************************}
{$ifndef cge}
   {$fatal COMPILE WITH -dcge KEY}
{$endif}
{$ifndef cgemodule}
   {$fatal COMPILE WITH -dcgemodule KEY}
{$endif}

{$memory 10000, 10000}   //Both values have no meaning.
  // First one - because DLLs use the host apps's stack,
  // Second one - because the heap can grow dynamically.

{$include mo_globaldefs.h}

{$stackframes on}

library _chentrah_module;

uses
  SysUtils,
  mo_hub,
  chepersy,
  mo_module,

  _my_module_main;

  function Initialize(p: PMotherState): boolean; export; cdecl;
  var
    t, stub: integer;
  begin
    try
      result:=true;
      GrandInitialize(p, MyModuleVersionMajor, MyModuleVersionMinor, MyModuleBuildNumber,
        [MyModuleString, VersionToStr(MyModuleVersionMajor, MyModuleVersionMinor, MyModuleBuildNumber),
          CompileDate, CompileTime, CompilerVersion, CompileTarget], MyModuleSessionSpaceLimit); //Here we go...
//      AddLog(MI_VERSION_INFO,[MyModuleString, VersionToStr(MyModuleVersionMajor, MyModuleVersionMinor, MyModuleBuildNumber), CompileDate, CompileTime, CompilerVersion, CompileTarget]);
      MyModClass:=MyModuleType;
//addlog(' paths:'#10#13'   %0'#10#13'   %1'#10#13'   %2',[m_selfname, m_sessionpath, m_savepath]);
    except
      Result:=false;
    end;
  end;

  function Pulse(): boolean; export; cdecl;
  begin
    try
      Result:=_Pulse();
    except
      Result:=false;
    end;
  end;
  
  function Save(): boolean; export; cdecl;
  begin
    Result:=_Save();
  end;
  
  function Free(): boolean; export; cdecl;
  begin
    Config.Free;
    Result:=_Free();
  end;

{$include mo_die1.inc}
{  //moved it to an include to allow ignoring it when call stack report is being built. It checks by source name

procedure PassUnhandledException; export; cdecl;
begin
  DieBySEhHack;
end;
}

exports
  Initialize name 'M_Init',
  PassUnhandledException name 'M_PassUnhandledException',
  Pulse name 'M_Pulse',
  Save name 'M_Save',
  Free name 'M_Free';

begin
 // do nothing. Doesn't work in Linux.
end.
