#set to 1 to recompile Vampyre Imaging library (must reside in 3rdparty/Imaging folder)
# If your FPC version doesn't work with supplied PPUs.
#(currently MUST be set to 1 or it won't compile)
COMPILE_VAMPYRE=1

#set to 1 to recompile accompanying tools (incbuild, brutalstrip and the like)
COMPILE_TOOLS=1

COMPILE_WIN32=1
COMPILE_LINUX=0

PACK_RELEASE=0
RELEASE_DIR=../../../tmp/chentrah/
RTDIR=../../../

#Must be installed in Wine
FPC_VER=2.6.2

#Paths must NOT contain spaces.
DRIVE_C=/home/${USER}/.wine/drive_c
COMPPATH=/FPC/${FPC_VER}/bin/i386-win32
BUILTIN=_test013
#these options cause a crash:
#  -OoTailRec -OoLoopUnRoll -CfSSE
#The main executable must NOT employ SSE2, otherwise it won't run
#  on the older CPUs like my spare AMD Sempron 2400+
#Unfortunately, the -cfSSE key does in fact activate SSE2.
#  Otherwise there would be no problem (Sempron 2400+ _does_ support SSE)
CODE_OPTIONS="-OpPentiumM -O3"
# -OoUncertain -OoRegVar -OoPeepHole -Ooasmcse"
# -CX (Create also smartlinked library)
#   saves about 100Kb on the Linux executable size
#   but by some reason prevents the Dwarf2 debug info from being generated
CGE_OPTIONS="-gw2 -Xi -XX -dcge -dnotlaz -Mdelphi -Sh -Sc -Rintel ${CODE_OPTIONS}"
CGE_PATHS="-FE../../../ -Fi../../${BUILTIN}/src/ -Fu../../${BUILTIN}/src/"
if [ $COMPILE_VAMPYRE == 1 ]
then
  VY_PATHS="-Fu../../../3rdparty/Imaging/Source/  -Fu../../../3rdparty/Imaging/Source/ZLib/  -Fi../../../3rdparty/Imaging/Source/ -Fu../../../3rdparty/Imaging/Source/JpegLib/"
else
  VY_PATHS="-Fu../../../3rdparty/bin/lin/ -Fu../../../3rdparty/bin/win/"
fi
#VY_PATHS="-Fu../../../3rdparty/Imaging/Source/ -Fu../../../3rdparty/Imaging/Source/JpegLib/ -Fu../../../3rdparty/Imaging/Source/ZLib/ -Fu../../../3rdparty/Imaging/Extras/Extensions/ -Fu../../../3rdparty/Imaging/Extras/Extensions/J2KObjects/ -Fi../../../3rdparty/Imaging/Source/"

mkdir /tmp/.chentrah
mkdir /tmp/.chentrah/main
mkdir /tmp/.chentrah/tools
mkdir ../../../tmp/
mkdir ../../../tmp/main
mkdir ../../../tmp/tools

#rm ../../../tmp/*

if [ $COMPILE_TOOLS == 1 ]
then
  rm /tmp/.chentrah/tools/*
  fpc extractdwrflnfo.pp -FE../../../bin/ -FU/tmp/.chentrah/tools/
  strip -s -x -X ../../../bin/extractdwrflnfo
  fpc finalizedwrflnfo.pp -FE../../../bin/ -FU/tmp/.chentrah/tools/
  strip -s -x -X ../../../bin/finalizedwrflnfo
  fpc brutalstrip.pp -FE../../../bin/ -FU/tmp/.chentrah/tools/
  strip -s -x -X ../../../bin/brutalstrip
  fpc incbuild.dpr -FE../../../bin/ -FU/tmp/.chentrah/tools/
  strip -s -x -X ../../../bin/incbuild
  #Removing the old PPUs is MANDATORY. The main program shares some units
  #  with these tools, but built with differend compiler switches.
  #  The compiler doesn't realise that, reusing the compiled units
  #  and making a TOTAL MESS.
  rm /tmp/.chentrah/tools/*
fi


if [ $COMPILE_VAMPYRE == 1 ]
then
  rm --recursive --verbose --one-file-system /tmp/.chentrah/main/*
  rm --recursive --verbose --one-file-system ../../../tmp/main/*
fi


bin2obj -o cl_builtin_font.inc -c builtin_font font.png
bin2obj -o cl_console_font.inc -c iim_console consolefont.png
bin2obj -o cl_bgimg_error.inc -c error_bg_img cl_background_error.png
bin2obj -o cl_cursor_cyan.inc -c cursor_cyan_img cl_cursor_normal.png
bin2obj -o cl_cursor_yellow.inc -c cursor_yellow_img cl_cursor_error.png
bin2obj -o cl_cursor_hourglass.inc -c cursor_hourglass_img cl_cursor_hourglass.png
bin2obj -o cl_minifont.inc -c minifont_img cl_minifont.png
bin2obj -o cl_errbutton.inc -c errbutton_img cl_errbutton.png
bin2obj -o cl_erricon.inc -c erricon_img cl_erricon.png
#bin2obj -o cl_j2k_test.inc -c j2k_test_image cl_test.jp2



#just to be sure there are no stray units in the sources folder
rm ./*.ppu
rm ./*.o

if [ $COMPILE_LINUX == 1 ]
then
  rm ../../../chentrah
  fpc chentrah.lpr ${CGE_OPTIONS} -Tlinux -FU/tmp/.chentrah/main/ ${CGE_PATHS} ${VY_PATHS}
  ../../../bin/extractdwrflnfo ../../../chentrah
  strip   -s -x -X  ../../../chentrah
  ../../../bin/finalizedwrflnfo ../../../chentrah
  mv ../../../chentrah.elf.zd2 ../bin/

  # *.a are generated only with the -CX key (I do not use it, see above).
  if [ $COMPILE_VAMPYRE == 1 ]
  then
    mv /tmp/.chentrah/main/Im*.ppu ../../../3rdparty/bin/lin/
    mv /tmp/.chentrah/main/Im*.o ../../../3rdparty/bin/lin/
  #  mv /tmp/.chentrah/libpIm*.a ../../../3rdparty/bin/lin/
    mv /tmp/.chentrah/main/im*.ppu ../../../3rdparty/bin/lin/
    mv /tmp/.chentrah/main/im*.o ../../../3rdparty/bin/lin/
  #  mv /tmp/.chentrah/libpim*.a ../../../3rdparty/bin/lin/
    mv /tmp/.chentrah/main/dzlib.ppu ../../../3rdparty/bin/lin/
    mv /tmp/.chentrah/main/dzlib.o ../../../3rdparty/bin/lin/
  #  mv /tmp/.chentrah/libpdzlib.a ../../../3rdparty/bin/lin/
  fi
fi

if [ $COMPILE_WIN32 == 1 ]
then
  rm ../../../chentrah.exe
  wrc chentrah.rc
  wine ${DRIVE_C}${COMPPATH}/ppc386.exe chentrah.lpr ${CGE_OPTIONS} -CX -Twin32 -FU../../../tmp/main/ ${CGE_PATHS} ${VY_PATHS}
  ../../../bin/incbuild build.h
  ../../../bin/brutalstrip ../../../chentrah.exe
  #UPX is mandatory, it fixes the executable broken by brutalstrip.
  #  (how does all of this work I have no slightest clue.
  #    I guess I missed some vital detail when I was writing brutalstrip)
  wine ${DRIVE_C}${COMPPATH}/upx.exe -9 --force ../../../chentrah.exe
  ../../../bin/finalizedwrflnfo ../../../chentrah.exe
#  mv ../../../chentrah.zd2 ../bin/

  if [ $COMPILE_VAMPYRE == 1 ]
  then
    mv ../../../tmp/main/Im*.ppu ../../../3rdparty/bin/win/
    mv ../../../tmp/main/Im*.o ../../../3rdparty/bin/win/
    mv ../../../tmp/main/im*.ppu ../../../3rdparty/bin/win/
    mv ../../../tmp/main/im*.o ../../../3rdparty/bin/win/
    mv ../../../tmp/main/dzlib.ppu ../../../3rdparty/bin/win/
    mv ../../../tmp/main/dzlib.o ../../../3rdparty/bin/win/
  fi
  #by some strange reason a folder named "e:" appears in the sources folder
  rm --recursive --verbose --one-file-system ./e:
fi


if [ $PACK_RELEASE == 1 ]
then
  rm --recursive --verbose --one-file-system ../../../tmp/*
  mkdir ${RELEASE_DIR}
  mkdir ${RELEASE_DIR}modules/
  cp -v -x ${RTDIR}chentrah ${RELEASE_DIR}
  cp -v -x ${RTDIR}chentrah.exe ${RELEASE_DIR}
  cp -v -x ${RTDIR}chentrah.ini ${RELEASE_DIR}
  cp -r -v -x ${RTDIR}modules/chentrah ${RELEASE_DIR}modules/

  rm ${RELEASE_DIR}modules/chentrah/src/backup/*
  rm ${RELEASE_DIR}modules/chentrah/src/test
  rm ${RELEASE_DIR}modules/chentrah/src/test.exe
  rm ${RELEASE_DIR}modules/chentrah/src/GenerateInterface
  rm ${RELEASE_DIR}modules/chentrah/src/PrepareForRelease
  rm ${RELEASE_DIR}modules/chentrah/src/_chepersy.pas
  rm ${RELEASE_DIR}modules/chentrah/src/__chepersy.pas
  rm ${RELEASE_DIR}modules/chentrah/src/___chepersy.pas
  rm ${RELEASE_DIR}modules/chentrah/src/chentrah.ico
  rm ${RELEASE_DIR}modules/chentrah/src/chentrah_macosx.ico
  rm ${RELEASE_DIR}modules/chentrah/src/*.bak

  cp -r -v -x ${RTDIR}modules/_test014 ${RELEASE_DIR}modules/
  cp    -v -x ${RTDIR}modules/_test014.module ${RELEASE_DIR}modules/
  cp -r -v -x ${RTDIR}license ${RELEASE_DIR}
  cp -r -v -x ${RTDIR}conf ${RELEASE_DIR}
  cd ${RELEASE_DIR}
  cd ../
  rm ../chentrah.zip
  zip -r ../chentrah.zip ./*
fi
