{
    This file is part of Chentrah,
    Copyright (C) 2004-2008 Anton Rzheshevski (chebmaster@mail.ru).

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/

 **********************************************************************

}
  
procedure CgeLoadCursorFromFile (FileName: PAnsiChar; xhotspot, yhotspot: integer); cdecl;
  var
    p: pointer;
  begin
    if not MotherState.WindowExists then Exit;
    try
      p:= LoadPicAs (FileName, GL_RGBA);
       CheckForGuardedException;
      if (GetPicWidth(p) <> 32) or (GetPicHeight(p) <> 32)
        then ResamplePic (p, 32, 32, false);
       CheckForGuardedException;
      WindowManager.SetPointerImage(GetPicPixels(p), xhotspot, yhotspot);
       CheckForGuardedException;
      DeletePic(p);
       CheckForGuardedException;
    except
      ProcessGuardedException();
    end;
  end;

  procedure CgeLoadCursorFromMemory (pfile: pointer; size, xhotspot, yhotspot: integer); cdecl;
  var p: pointer;
  begin
    if not MotherState.WindowExists then Exit;
    try
      p:= LoadPicFromMemAs (pfile, size, GL_RGBA);
       CheckForGuardedException;
      if (GetPicWidth(p) <> 32) or (GetPicHeight(p) <> 32)
        then ResamplePic (p, 32, 32, false);
       CheckForGuardedException;
      WindowManager.SetPointerImage(GetPicPixels(p), xhotspot, yhotspot);
       CheckForGuardedException;
      DeletePic(p);
       CheckForGuardedException;
    except
      ProcessGuardedException();
    end;
  end;

  procedure CgeLoadCursorFromRawPixmap (pixels: pointer; xhotspot, yhotspot: integer); cdecl;
  begin
    if not MotherState.WindowExists then Exit;
    try
      WindowManager.SetPointerImage(pixels, xhotspot, yhotspot);
    except
      ProcessGuardedException();
    end;
  end;

  procedure CgeEmptyCursor(); cdecl;
  begin
    if not MotherState.WindowExists then Exit;
    try
      WindowManager.SetPointerImage(nil, 0, 0);
    except
      ProcessGuardedException();
    end;
  end;
  
  procedure CgeStandardCursor(); cdecl;
  begin
    if not MotherState.WindowExists then Exit;
    try
      CgeLoadCursorFromMemory(@cursor_cyan_img, sizeof(cursor_cyan_img),
                           CGE_STD_CURSOR_HOTSPOT_X, CGE_STD_CURSOR_HOTSPOT_Y);
       CheckForGuardedException;
    except
      ProcessGuardedException();
    end;
  end;

  procedure _CgeErrorCursor(); // not exported, for internal use only.
  begin
    if not MotherState.WindowExists then Exit;
    CgeLoadCursorFromMemory(@cursor_yellow_img, sizeof(cursor_yellow_img),
                             CGE_ERR_CURSOR_HOTSPOT_X, CGE_ERR_CURSOR_HOTSPOT_Y);
    CheckForGuardedException; //just crash if exception.
  end;

  procedure CgeHourglassCursor(); cdecl;
  begin
    if not MotherState.WindowExists then Exit;
    try
      CgeLoadCursorFromMemory(@cursor_hourglass_img, sizeof(cursor_hourglass_img),
                           CGE_HRGLASS_CURSOR_HOTSPOT_X, CGE_HRGLASS_CURSOR_HOTSPOT_Y);
       CheckForGuardedException;
    except
      ProcessGuardedException();
    end;
  end;


