{
    This file is part of Chentrah,
    Copyright (C) 2004-2008 Anton Rzheshevski (chebmaster@mail.ru).

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/

 **********************************************************************

}
{$ifdef fpc}
  {$include cl_dyna_freepascal.inc}
{$else}
  //Delphi, such an asshole, doesn't support macros!
  //use CFDD to utility to auto-convert
  //  cl_dyna_freepascal.h into cl_dyna_delphi.h.
  {$include cl_dyna_delphi.inc}
{$endif}

{ TDyna }

constructor TDyna.Create;
begin
  inherited;
  s:=0;
  sm:=0;
  es:=4;
end;

procedure TDyna.Decrement;
begin
  Assert(s > 0,'attempt to decrement TDyna, which length is zero');
  ReSize(s - 1);
end;

destructor TDyna.Destroy;
begin
  resize(0);
  inherited;
end;

function TDyna.GetHigh: integer;
begin
  Result:=s-1;
end;

function TDyna.GetSize: integer;
begin
  Result:=s;
end;

procedure TDyna.Increment;
begin
  ReSize(s+1);
end;

procedure TDyna.Resize(newLen: integer);
var t, n: integer;
begin
 { if sm=0 then begin
    if newLen=0 then Exit
    else begin
      sm:=NewLen;
    end;
  end
  else begin
    if newLen=0 then begin
      sm:=0;
    end
    else begin
      if NewLen > sm then begin
        sm:=((NewLen shr 3) + 1) shl 3;
      end
      else begin
        t:=sm shr 3;
        if (sm - NewLen > t) then begin
          sm:=NewLen;
        end;
      end;
    end;
  end; }
  sm:=NewLen;
  _Resize(NewLen);
  s:=NewLen;
end;

procedure TDYNA.SetRect(a, b: integer);
begin
  Assert(b = 1, 'TDyna: attempt to set second dimension of the one-dimensional array');
  Resize(a);
end;

