{
    This file is part of Chentrah,
    Copyright (C) 2004-2008 Anton Rzheshevski (chebmaster@mail.ru).

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/

 **********************************************************************

    This file contains source of the test module #013.

 **********************************************************************}

{$include mo_globaldefs.h}
{$stackframes off}

unit cl_internalmodule;

interface
uses
  SysUtils,
  mo_hub,
  chepersy,
  mo_module,

  _my_module_main;
  
  const
    MyInternalModuleName = _my_module_main.MyModuleString;//'Test #13';
    MyInternalModuleBasePath = _my_module_main.MyInternalModuleBasePath;//'_test014';

  function IM_Init(p: PMotherState): boolean; cdecl;
  function IM_Pulse(): boolean; cdecl;
  function IM_Save(): boolean; cdecl;
  function IM_Free(): boolean; cdecl;

  

implementation
  var AlreadyInitialized: boolean = false;

  function IM_Init(p: PMotherState): boolean; cdecl;
  var
    t, stub: integer;
  begin
    if AlreadyInitialized then Exit(true);
    try
      result:=true;
      GrandInitialize(p, MyModuleVersionMajor, MyModuleVersionMinor, MyModuleBuildNumber,
        [MyModuleString, VersionToStr(MyModuleVersionMajor, MyModuleVersionMinor, MyModuleBuildNumber),
          CompileDate, CompileTime, CompilerVersion, CompileTarget], MyModuleSessionSpaceLimit); //Here we go...
//      AddLog(MI_VERSION_INFO,[MyModuleString, VersionToStr(MyModuleVersionMajor, MyModuleVersionMinor, MyModuleBuildNumber), CompileDate, CompileTime, CompilerVersion, CompileTarget]);
      MyModClass:=MyModuleType;
//addlog(' paths:'#10#13'   %0'#10#13'   %1'#10#13'   %2',[m_selfname, m_sessionpath, m_savepath]);
      AlreadyInitialized:= true;
    except
      Result:=false;
    end;
  end;

  function IM_Pulse(): boolean; cdecl;
  begin
    try
      Result:=_Pulse();
    except
      Result:=false;
    end;
  end;

  function IM_Save(): boolean; cdecl;
  begin
    Result:=_Save();
  end;
  
  function IM_Free(): boolean; cdecl;
  begin
    Result:=_Free();
  end;
end.
