{
    This file is part of Chentrah,
    Copyright (C) 2004-2009 Anton Rzheshevski (chebmaster@mail.ru).

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/

 **********************************************************************}

{
 Lockup Guard is a separate thread that checks periodically if the
   main application thread stopped responding, in which cause
   it terminates the application and restarts it to output an
   appropriate error message. }
type
  TLockupCause = (luc_Checkup, luc_SoundSystemStart, luc_VideoSystemStart);

const
  LockupTimeout: array [TLockupCause] of integer = (60, 10, 30);

  LockupCauseName: array[TLockupCause] of WideString =
   ('', 'при запуске OpenAL', 'при запуске OpenGL');

  LockupCauseNameEn: array[TLockupCause] of WideString =
   ('', 'while starting up OpenAL', 'while starting up OpenGL');

type
  TLockupGuard = class (TThread)
  protected
    cs: TCriticalSection;//TRTLCriticalSection;
    f_timeout: TDateTime;
    f_checkup_timeout: TDateTime;
    f_cause: TLockupCause;
    procedure Execute; override;
  public
    NowRestartingAfterLockup: boolean;
    LockupCause: TLockupCause;
    LockupCauseStr: WideString;
    constructor Create;
    destructor Destroy;
    procedure Guard(p: TProcedure; op: TLockupCause; timeout: integer = -1);
    procedure DieAndBeReborn;
    procedure Checkup; // to be called each cycle, or else!
    procedure Freeze; //stops functioning until the next call to Checkup()
  end;

var
  LockupGuard: TLockupGuard;

threadvar
  CheckupTime: TDateTime;


