Type

  { TModule }
  TModuleParams = record
    Name: WideString;
    Dll,
    PureN: ansistring;
    RequiresOpenGL2: boolean;
    ThreadStackSize: PtrUint;
  end;

  TModule = class (TObject)
    constructor Create;
    destructor Destroy; OVERRIDE;
  protected
     _Fname, _FromDir, _ToDir, _Basedir, _dllname: ansistring;
     DLL: {$ifdef unix} pointer {$else} THandle {$endif} ;
     M_Initialize: function(ms: PMotherState): boolean; cdecl;
     M_Pulse,
     M_Save,
     M_Free: function (): boolean; cdecl;
     f_dll_age,
     f_bad_age: longint;
     f_reload_failed_msg: WideString;
     f_Index, f_IndexToLoad,
     PrevModuleDateCheckTick,
     ModuleCheckPeriod: longint;
     ListAlreadyBuilt: boolean;
     PureName: AnsiString;
     procedure _RebuildModulesList;
     procedure _LoadAddresses;
     function _GetProcAddress(ProcName: pchar): Pointer;
     function _GetFname: string;
     procedure _LoadMeDll(n: string);
     procedure _UnloadMeDll;
     procedure _Initialize;
     procedure _SwitchToStopScreen(itisfatal: boolean);
     procedure _Processfatality;

  public
{    ModuleName: array of WideString;
    ModuleDll,
    ModulePureN: array of ansistring;}
    MList: array of TModuleParams;
    HasFocus, SwitchedConsoleOff: boolean;
    BimLoaded: boolean;
    ReloadAt: longint; //in tickcounts
    AttemptNum: integer;
   {$ifndef buildmein}
    PassUnhandledException: procedure; cdecl;
    property DllHandle: {$ifdef unix} pointer {$else} THandle {$endif} read DLL;
   {$endif}

//    function InputMessage (msg: TCbMessage; par0, par1, par2: integer): boolean;
//    function ProcessMessage (msg: TCbMessage; par0, par1, par2: integer): boolean;
    procedure Load;
    procedure Unload;
    property ErrorMessage: WideString read f_reload_failed_msg;
    property Fname: ansistring read _fname;
    property Index: integer read f_index;
    property IndexToLoad: integer read f_indexToLoad;
//    property Active: boolean read f_active;
//    property Loaded: boolean read f_loaded;

    procedure Reload(i: integer);
    
    function Pulse(): boolean;
    
    procedure EraseSession(modnum: integer); virtual; abstract;
    function GetDefaultNum: integer;

    procedure Checkdate;

    procedure ReactToSpace;
    procedure ReactToEsc;

    procedure GoToModuleSelectionMenu;
    procedure RollBackSession;

 end;


var
  Module: TModule = nil;

