{
    This file is part of chepersy
    Copyright (c) 2004-2008 by Anton Rzheshevski (chebmaster@mail.ru),

    See the file COPYING.CPS, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}



//********  CGE  FILE  FUNCTIONS  ********************

//One at time, kids! No multi-threading, no interruption.










    class procedure TChepersyDatabaseHeader.CgeFilePropByType(t: AnsiChar; name: WideString);
    begin
      C.Sig.sign:='CGE';
      Case t of
        {$ifdef support08x}
        '0', 's': begin
          StreamVersion:= 0;
          BasketWarningsAdd(RuEn('Устаревший формат потока данных от Chepersy 0.8 или ниже',
                                 'Obsolete data stream format, from Chepersy 0.8 or below'))
         end;
        {$endif}
        '1': StreamVersion:= 1;
        '2': StreamVersion:= 2;
      else
        Die(MI_CGEFILE_UNSUPPORTED, [Name, 'CGE' + t])
      end;
    end;



  procedure TChepersyDatabaseHeader.WriteSignatureToStream;
  begin
    C.Sig.sign:='CGE';
    C.Sig.ver:= '2';

    if CpsStream is TFileStream
      then C.FN:=(CpsStream as TFileStream).FileName
      else C.FN:=CpsStream.ClassName;
    Try
      CpsStream.Write(C.Sig, SizeOf(C.Sig));

      //added since 0.9.0, header checksum
      CpsStream.Write(CurrentVersionChecksum, SizeOf(CurrentVersionChecksum));
      CpsStream.WriteDword(CurrentVersionHeaderSize);
    Except
      Die(MI_CGEFILE_ERROR_WRITE, [C.FN]);
    End;
    C.Opened:=Yes;
    C.Read:=No;
  end;



  class procedure TChepersyDatabaseHeader.ReadSignatureFromStream  (var version: AnsiChar);
  begin
    if CpsStream  is TFileStream
      then C.FN:=(CpsStream  as TFileStream).FileName
      else C.FN:=CpsStream .ClassName;
    Try
      CpsStream.Read(C.Sig, SizeOf(C.Sig));
      //format checking
      if C.Sig.sign <> 'CGE'
        then Die(MI_CGEFILE_CORRUPT, [C.FN, RuEn('Неверная сигнатура', 'Wrong signature')]);
      CgeFilePropByType(C.Sig.ver, C.FN);
      {$ifdef support08x}
      if StreamVersion = 0 then CpsStream.Read(C.Head, Sizeof(C.Head));
      {$endif}
      if StreamVersion >= 2 then begin
        CpsStream.Read(ReadChecksum, SizeOf(ReadChecksum));
        ReadHeaderSize:= CpsStream.ReadDword;
      end;
    Except
      Die(MI_CGEFILE_ERROR_READ, [C.FN]);
    End;
    version:=C.Sig.ver;
    C.Opened:=Yes;
    C.Read:=Yes;
  end;


  procedure CloseCGEFile (FreeTheStream: boolean);
  begin
    if not DH.C.Opened then Die(MI_ERROR_PROGRAMMER_NO_BAKA, ['Attempt to close an already closed stream.']);
    if DH.C.Read then begin
      if FreeTheStream
        then CpsStream.Free;
      CpsStream:= nil;
    end
    else begin
      Try
        if FreeTheStream
          then CpsStream.Free;
        CpsStream:= nil;
      Except
        Die(MI_CGEFILE_ERROR_WRITE, [DH.C.FN]);
      End;
    end;
    DH.C.Opened:=No;
  end;
  
  
  procedure EmergencyCloseCGEFile; cdecl;
  var
    fn: string;
    f: file;
  begin
    CpsStream:= nil;
    if CpsStream is TFileStream then fn:=(CpsStream as TFileStream).FileName else fn:='';
    CpsStream.Free;
    if not DH.C.Opened then Exit;
    DH.C.Opened:=No;
    if (fn <> '') and not (DH.C.Read) then begin
      Assign(f, fn);
      Erase(f);
    end;
  end;

