{
    This file is part of chepersy
    Copyright (c) 2004-2008 by Anton Rzheshevski (chebmaster@mail.ru),

    See the file COPYING.CPS, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}
function TAOS.Add(i: AnsiString):integer;
begin
  Increment;
  Last:=i;
  Result:=High;
end;

procedure TAOS.ClearMem;
var j: integer;
begin
  For j:=0 to High do m[j]:='';
end;

procedure TAOS._Resize(L: integer);
var j, os: integer;
begin
  if L < s then For j:=L to s - 1 do D[j]:='';
  SetLength(m, sm);
  os:=s;
  s:=L;
  if L > os then For j:=os to L - 1 do D[j]:='';
end;


function TAOS._Read(ind: cardinal): AnsiString;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'reading from one-dimensional TDyna descendant: invalid index, out of array boundaries');
  Result:=m[ind];
end;

function TAOS._ReadDPTR: pointer;
begin
  if s=0 then Result:=nil else result:=@(m[0]);
end;


function TAOS._ReadLast: AnsiString;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  Result:=m[s-1];
end;

procedure TAOS._Write(ind: cardinal; p: AnsiString);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to one-dimensional TDyna descendant: invalid index, out of array boundaries');
  m[ind]:=p;
end;

procedure TAOS._WriteLast(p: AnsiString);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  m[s-1]:=p;
end;

procedure TAOS.Save();
var
  i: integer;
begin
  {$ifdef fpc}
  {$ifdef fpc} CpsStream.WriteDword( {$else} WriteInt( {$endif}Self.Length);
  {$else}
  WriteInt(Self.Length);
  {$endif}
  For i:=0 to Self.Length - 1 do begin
       WriteAnsiString(Self[i]);
  end;
end;

procedure TAOS.Load(Lsz: integer);
var
  i: integer;
begin
  Self.Length:= Lsz;//ReadInt(); //I had to get rid of the PeekInt() function
  For i:=0 to Self.Length - 1 do begin
     Self[i]:=ReadAnsiString();
  end;
end;

function TAOS._ReadNext: AnsiString;
begin
  Assert (CurrentMmb <= Self.High, 'TDyna descendant: reading Next property violated array bondaries.');
  Result:=D[CurrentMmb];
  Inc(CurrentMmb);
end;

function TAOS._ReadFirst: AnsiString;
begin
  Result:=D[0];
  CurrentMmb:=1;
end;

  procedure RP_TAOS (PField: pointer; OP: TFieldOperation; Tind: integer); register;
  var
    o: TAOS;
    s: integer;
  begin
    case op of
      fio_Load: begin
                  s:= {$ifdef fpc} {$ifdef fpc} CpsStream.ReadDword() {$else} ReadInt() {$endif}; {$else} ReadInt(); {$endif}
                  if s < 0 then pointer(PField^):=nil
                  else begin
                    TAOS(PField^):=TAOS.Create;
                    TAOS(PField^).Load(s);
                  end;
                end;
      fio_Save: if Assigned(pointer(PField^))
                  then TAOS(PField^).Save
                  else WriteNil;
      fio_Skip: begin
                  s:= {$ifdef fpc} CpsStream.ReadDword() {$else} ReadInt() {$endif};
                  if s >= 0 then begin
                    o:=TAOS.Create; //load it and destroy it. The fate is cruel.
                    o.Load(s);
                    o.Free;
                  end;
                end;
    end;
  end;

function T2DAOS._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of a two-dimensional TDyna descendant');
  Result:=nil;
end;

function T2DAOS._Read(ind: cardinal): TAOS;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind)>=0) and (integer(ind) < s), 'reading from two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  Result:=TAOS(a[ind]);
end;

procedure T2DAOS._Write(ind: cardinal; p: TAOS);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  a[ind]:=pointer(p);
end;

procedure T2DAOS._Resize(L: integer);
var j: integer;
begin
  if L < s then For j:=L to s - 1 do begin TAOS(a[j]).Free; a[j]:=nil end;
  SetLength(a, sm);
  if L > s then For j:=s to L - 1 do a[j]:= pointer(TAOS.Create);
end;

function T2DAOS._ReadLast: TAOS;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Result:=TAOS(a[s-1]);
end;

procedure T2DAOS._WriteLast(z: TAOS);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  a[s - 1]:= pointer(z);
end;

procedure T2DAOS.SetRect(z, b: integer);
var
  x: integer;
begin
  Length:=z;
  For x:=0 to High do D[x].Length:=b;
end;

procedure T2DAOS.ClearMem;
var j: integer;
begin
  For j:=0 to High do D[j].ClearMem;
end;

procedure T2DAOS.Save();
var i: integer;
begin
  {$ifdef fpc} CpsStream.WriteDword( {$else} WriteInt( {$endif}Self.Length);
  For i:=0 to Self.High do
    Self[i].Save;
end;

procedure T2DAOS.Load(Lsz: integer);
var i: integer;
begin
  Self.Length:=Lsz;//ReadInt();
  For i:=0 to Self.High do
    Self[i].Load(ReadInt());
end;

  procedure RP_T2DAOS (PField: pointer; OP: TFieldOperation; Tind: integer); register;
  var
    o: T2DAOS;
    s: integer;
  begin
    case op of
      fio_Load: begin
                  s:= {$ifdef fpc} CpsStream.ReadDword() {$else} ReadInt() {$endif};
                  if s < 0 then pointer(PField^):=nil
                  else begin
                    T2DAOS(PField^):=T2DAOS.Create;
                    T2DAOS(PField^).Load(s);
                  end;
                end;
      fio_Save: if Assigned(pointer(PField^))
                  then T2DAOS(PField^).Save
                  else WriteNil;
      fio_Skip: begin
                  s:= {$ifdef fpc} CpsStream.ReadDword() {$else} ReadInt() {$endif};
                  if s >= 0 then begin
                    o:=T2DAOS.Create; //load it and destroy it. The fate is cruel.
                    o.Load(s);
                    o.Free;
                  end
                end;
    end;
  end;

function TAOW.Add(i: WideString):integer;
begin
  Increment;
  Last:=i;
  Result:=High;
end;

procedure TAOW.ClearMem;
var j: integer;
begin
  For j:=0 to High do
       m[j]:='';
end;

procedure TAOW._Resize(L: integer);
var j, os: integer;
begin
      if L < s then For j:=L to s - 1 do D[j]:='';
  os:=s;
  s:=L;
  if L > os then
      For j:=os to L - 1 do D[j]:='';
end;


function TAOW._Read(ind: cardinal): WideString;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'reading from one-dimensional TDyna descendant: invalid index, out of array boundaries');
    Result:=m[ind];
end;

function TAOW._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of one-dimensional TDyna descendant which is a string array');
  Result:=nil;
end;


function TAOW._ReadLast: WideString;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  Result:=m[s-1];
end;

procedure TAOW._Write(ind: cardinal; p: WideString);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to one-dimensional TDyna descendant: invalid index, out of array boundaries');
  m[ind]:=p;
end;

procedure TAOW._WriteLast(p: WideString);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  m[s-1]:=p;
end;

procedure TAOW.Save();
var
  i: integer;
begin
  {$ifdef fpc} CpsStream.WriteDword( {$else} WriteInt( {$endif}Self.Length);
  For i:=0 to Self.Length - 1 do begin
         WriteWideString(Self[i]);
  end;
end;

procedure TAOW.Load(Lsz: integer);
var
  i: integer;
begin
  Self.Length:= Lsz;//ReadInt(); //I had to get rid of the PeekInt() function
  For i:=0 to Self.Length - 1 do begin
         Self[i]:=ReadWideString();
  end;
end;

function TAOW._ReadNext: WideString;
begin
  Assert (CurrentMmb <= Self.High, 'TDyna descendant: reading Next property violated array bondaries.');
  Result:=D[CurrentMmb];
  Inc(CurrentMmb);
end;

function TAOW._ReadFirst: WideString;
begin
  Result:=D[0];
  CurrentMmb:=1;
end;

  procedure RP_TAOW (PField: pointer; OP: TFieldOperation; Tind: integer); register;
  var
    o: TAOW;
    s: integer;
  begin
    case op of
      fio_Load: begin
                  s:= {$ifdef fpc} CpsStream.ReadDword() {$else} ReadInt() {$endif};
                  if s < 0 then pointer(PField^):=nil
                  else begin
                    TAOW(PField^):=TAOW.Create;
                    TAOW(PField^).Load(s);
                  end;
                end;
      fio_Save: if Assigned(pointer(PField^))
                  then TAOW(PField^).Save
                  else WriteNil;
      fio_Skip: begin
                  s:={$ifdef fpc} CpsStream.ReadDword() {$else} ReadInt() {$endif};
                  if s >= 0 then begin
                    o:=TAOW.Create; //load it and destroy it. The fate is cruel.
                    o.Load(s);
                    o.Free;
                  end;
                end;
    end;
  end;

function T2DAOW._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of a two-dimensional TDyna descendant');
  Result:=nil;
end;

function T2DAOW._Read(ind: cardinal): TAOW;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind)>=0) and (integer(ind) < s), 'reading from two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  Result:=TAOW(a[ind]);
end;

procedure T2DAOW._Write(ind: cardinal; p: TAOW);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  a[ind]:=pointer(p);
end;

procedure T2DAOW._Resize(L: integer);
var j: integer;
begin
  if L < s then For j:=L to s - 1 do begin TAOW(a[j]).Free; a[j]:=nil end;
  SetLength(a, sm);
  if L > s then For j:=s to L - 1 do a[j]:= pointer(TAOW.Create);
end;

function T2DAOW._ReadLast: TAOW;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Result:=TAOW(a[s-1]);
end;

procedure T2DAOW._WriteLast(z: TAOW);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  a[s - 1]:= pointer(z);
end;

procedure T2DAOW.SetRect(z, b: integer);
var
  x: integer;
begin
  Length:=z;
  For x:=0 to High do D[x].Length:=b;
end;

procedure T2DAOW.ClearMem;
var j: integer;
begin
  For j:=0 to High do D[j].ClearMem;
end;

procedure T2DAOW.Save();
var i: integer;
begin
  {$ifdef fpc} CpsStream.WriteDword( {$else} WriteInt( {$endif}Self.Length);
  For i:=0 to Self.High do
    Self[i].Save;
end;

procedure T2DAOW.Load(Lsz: integer);
var i: integer;
begin
  Self.Length:=Lsz;//ReadInt();
  For i:=0 to Self.High do
    Self[i].Load(ReadInt());
end;

  procedure RP_T2DAOW (PField: pointer; OP: TFieldOperation; Tind: integer); register;
  var
    o: T2DAOW;
    s: integer;
  begin
    case op of
      fio_Load: begin
                  s:= {$ifdef fpc} CpsStream.ReadDword() {$else} ReadInt() {$endif};
                  if s < 0 then pointer(PField^):=nil
                  else begin
                    T2DAOW(PField^):=T2DAOW.Create;
                    T2DAOW(PField^).Load(s);
                  end;
                end;
      fio_Save: if Assigned(pointer(PField^))
                  then T2DAOW(PField^).Save
                  else WriteNil;
      fio_Skip: begin
                  s:= {$ifdef fpc} CpsStream.ReadDword() {$else} ReadInt() {$endif};
                  if s >= 0 then begin
                    o:=T2DAOW.Create; //load it and destroy it. The fate is cruel.
                    o.Load(s);
                    o.Free;
                  end
                end;
    end;
  end;

function TAOF.Add(i: float):integer;
begin
  Increment;
  Last:=i;
  Result:=High;
end;

procedure TAOF.ClearMem;
var j: integer;
begin
  For j:=0 to High do
    FillChar(m[j], SizeOf(m[0]), 0);
end;

procedure TAOF._Resize(L: integer);
var j, os: integer;
begin
    SetLength(m, sm);
  os:=s;
  s:=L;
  if L > os then
      For j:=os to L - 1 do FillChar(m[j], SizeOf(m[0]), 0);
end;


function TAOF._Read(ind: cardinal): float;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'reading from one-dimensional TDyna descendant: invalid index, out of array boundaries');
    Result:=m[ind];
end;

function TAOF._ReadDPTR: pointer;
begin
  if s=0 then Result:=nil else result:=@(m[0]);
end;


function TAOF._ReadLast: float;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  Result:=m[s-1];
end;

procedure TAOF._Write(ind: cardinal; p: float);
begin

  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to one-dimensional TDyna descendant: invalid index, out of array boundaries');
  m[ind]:=p;
end;

procedure TAOF._WriteLast(p: float);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  m[s-1]:=p;
end;

procedure TAOF.Save();
var
  i: integer;
  v: float;
begin
  {$ifdef fpc} CpsStream.WriteDword( {$else} WriteInt( {$endif}Self.Length);
  For i:=0 to Self.Length - 1 do begin
       v:=Self[i];
       CpsStream.Write(v, 4 * SizeOf(v) div SizeOf(integer));
       Assert(((Sizeof(v) div 4) * 4) = Sizeof(v), 'TDyna should be based on types whose size is multiply of 4')
  end;
//addLogOk;
end;

procedure TAOF.Load(Lsz: integer);
var
  i: integer;
  v: float;
begin
  Self.Length:= Lsz;//ReadInt(); //I had to get rid of the PeekInt() function
  For i:=0 to Self.Length - 1 do begin
       CpsStream.Read(v, 4 * SizeOf(v) div sizeof(integer));
       Self[i]:=v;
  end;
end;

function TAOF._ReadNext: float;
begin
  Assert (CurrentMmb <= Self.High, 'TDyna descendant: reading Next property violated array bondaries.');
  Result:=D[CurrentMmb];
  Inc(CurrentMmb);
end;

function TAOF._ReadFirst: float;
begin
  Result:=D[0];
  CurrentMmb:=1;
end;

  procedure RP_TAOF (PField: pointer; OP: TFieldOperation; Tind: integer); register;
  var
    o: TAOF;
    s: integer;
  begin
    case op of
      fio_Load: begin
                  s:= {$ifdef fpc} CpsStream.ReadDword() {$else} ReadInt() {$endif};
                  if s < 0 then pointer(PField^):=nil
                  else begin
                    TAOF(PField^):=TAOF.Create;
                    TAOF(PField^).Load(s);
                  end;
                end;
      fio_Save: if Assigned(pointer(PField^))
                  then TAOF(PField^).Save
                  else WriteNil;
      fio_Skip: begin
                  s:={$ifdef fpc} CpsStream.ReadDword() {$else} ReadInt() {$endif};
                  if s >= 0 then begin
                    o:=TAOF.Create; //load it and destroy it. The fate is cruel.
                    o.Load(s);
                    o.Free;
                  end;
                end;
    end;
  end;

function T2DAOF._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of a two-dimensional TDyna descendant');
  Result:=nil;
end;

function T2DAOF._Read(ind: cardinal): TAOF;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind)>=0) and (integer(ind) < s), 'reading from two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  Result:=TAOF(a[ind]);
end;

procedure T2DAOF._Write(ind: cardinal; p: TAOF);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  a[ind]:=pointer(p);
end;

procedure T2DAOF._Resize(L: integer);
var j: integer;
begin
  if L < s then For j:=L to s - 1 do begin TAOF(a[j]).Free; a[j]:=nil end;
  SetLength(a, sm);
  if L > s then For j:=s to L - 1 do a[j]:= pointer(TAOF.Create);
end;

function T2DAOF._ReadLast: TAOF;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Result:=TAOF(a[s-1]);
end;

procedure T2DAOF._WriteLast(z: TAOF);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  a[s - 1]:= pointer(z);
end;

procedure T2DAOF.SetRect(z, b: integer);
var
  x: integer;
begin
  Length:=z;
  For x:=0 to High do D[x].Length:=b;
end;

procedure T2DAOF.ClearMem;
var j: integer;
begin
  For j:=0 to High do D[j].ClearMem;
end;

procedure T2DAOF.Save();
var i: integer;
begin
  {$ifdef fpc} CpsStream.WriteDword( {$else} WriteInt( {$endif}Self.Length);
  For i:=0 to Self.High do
    Self[i].Save;
end;

procedure T2DAOF.Load(Lsz: integer);
var i: integer;
begin
  Self.Length:=Lsz;//ReadInt();
  For i:=0 to Self.High do
    Self[i].Load(ReadInt());
end;

  procedure RP_T2DAOF (PField: pointer; OP: TFieldOperation; Tind: integer); register;
  var
    o: T2DAOF;
    s: integer;
  begin
    case op of
      fio_Load: begin
                  s:= {$ifdef fpc} CpsStream.ReadDword() {$else} ReadInt() {$endif};
                  if s < 0 then pointer(PField^):=nil
                  else begin
                    T2DAOF(PField^):=T2DAOF.Create;
                    T2DAOF(PField^).Load(s);
                  end;
                end;
      fio_Save: if Assigned(pointer(PField^))
                  then T2DAOF(PField^).Save
                  else WriteNil;
      fio_Skip: begin
                  s:= {$ifdef fpc} CpsStream.ReadDword() {$else} ReadInt() {$endif};
                  if s >= 0 then begin
                    o:=T2DAOF.Create; //load it and destroy it. The fate is cruel.
                    o.Load(s);
                    o.Free;
                  end
                end;
    end;
  end;

function TAOC.Add(i: cardinal):integer;
begin
  Increment;
  Last:=i;
  Result:=High;
end;

procedure TAOC.ClearMem;
var j: integer;
begin
  For j:=0 to High do
       FillChar(m[j], SizeOf(m[0]), 0);
end;

procedure TAOC._Resize(L: integer);
var j, os: integer;
begin
    SetLength(m, sm);
  os:=s;
  s:=L;
  if L > os then
      For j:=os to L - 1 do FillChar(m[j], SizeOf(m[0]), 0);
end;


function TAOC._Read(ind: cardinal): cardinal;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'reading from one-dimensional TDyna descendant: invalid index, out of array boundaries');
    Result:=m[ind];
end;

function TAOC._ReadDPTR: pointer;
begin
  if s=0 then Result:=nil else result:=@(m[0]);
end;


function TAOC._ReadLast: cardinal;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  Result:=m[s-1];
end;

procedure TAOC._Write(ind: cardinal; p: cardinal);
begin

  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to one-dimensional TDyna descendant: invalid index, out of array boundaries');
  m[ind]:=p;
end;

procedure TAOC._WriteLast(p: cardinal);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  m[s-1]:=p;
end;

procedure TAOC.Save();
var
  i: integer;
  v: cardinal;
begin
  {$ifdef fpc} CpsStream.WriteDword( {$else} WriteInt( {$endif}Self.Length);
  For i:=0 to Self.Length - 1 do begin
       v:=Self[i];
       CpsStream.Write(v, 4 * SizeOf(v) div SizeOf(integer));
       Assert(((Sizeof(v) div 4) * 4) = Sizeof(v), 'TDyna should be based on types whose size is multiply of 4')
  end;
end;

procedure TAOC.Load(Lsz: integer);
var
  i: integer;
  v: cardinal;
begin
  Self.Length:= Lsz;//ReadInt(); //I had to get rid of the PeekInt() function
  For i:=0 to Self.Length - 1 do begin
       CpsStream.Read(v, 4 * SizeOf(v) div sizeof(integer));
       Self[i]:=v;
  end;
end;

function TAOC._ReadNext: cardinal;
begin
  Assert (CurrentMmb <= Self.High, 'TDyna descendant: reading Next property violated array bondaries.');
  Result:=D[CurrentMmb];
  Inc(CurrentMmb);
end;

function TAOC._ReadFirst: cardinal;
begin
  Result:=D[0];
  CurrentMmb:=1;
end;

  procedure RP_TAOC (PField: pointer; OP: TFieldOperation; Tind: integer); register;
  var
    o: TAOC;
    s: integer;
  begin
    case op of
      fio_Load: begin
                  s:= {$ifdef fpc} CpsStream.ReadDword() {$else} ReadInt() {$endif};
                  if s < 0 then pointer(PField^):=nil
                  else begin
                    TAOC(PField^):=TAOC.Create;
                    TAOC(PField^).Load(s);
                  end;
                end;
      fio_Save: if Assigned(pointer(PField^))
                  then TAOC(PField^).Save
                  else WriteNil;
      fio_Skip: begin
                  s:={$ifdef fpc} CpsStream.ReadDword() {$else} ReadInt() {$endif};
                  if s >= 0 then begin
                    o:=TAOC.Create; //load it and destroy it. The fate is cruel.
                    o.Load(s);
                    o.Free;
                  end;
                end;
    end;
  end;

function T2DAOC._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of a two-dimensional TDyna descendant');
  Result:=nil;
end;

function T2DAOC._Read(ind: cardinal): TAOC;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind)>=0) and (integer(ind) < s), 'reading from two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  Result:=TAOC(a[ind]);
end;

procedure T2DAOC._Write(ind: cardinal; p: TAOC);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  a[ind]:=pointer(p);
end;

procedure T2DAOC._Resize(L: integer);
var j: integer;
begin
  if L < s then For j:=L to s - 1 do begin TAOC(a[j]).Free; a[j]:=nil end;
  SetLength(a, sm);
  if L > s then For j:=s to L - 1 do a[j]:= pointer(TAOC.Create);
end;

function T2DAOC._ReadLast: TAOC;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Result:=TAOC(a[s-1]);
end;

procedure T2DAOC._WriteLast(z: TAOC);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  a[s - 1]:= pointer(z);
end;

procedure T2DAOC.SetRect(z, b: integer);
var
  x: integer;
begin
  Length:=z;
  For x:=0 to High do D[x].Length:=b;
end;

procedure T2DAOC.ClearMem;
var j: integer;
begin
  For j:=0 to High do D[j].ClearMem;
end;

procedure T2DAOC.Save();
var i: integer;
begin
  {$ifdef fpc} CpsStream.WriteDword( {$else} WriteInt( {$endif}Self.Length);
  For i:=0 to Self.High do
    Self[i].Save;
end;

procedure T2DAOC.Load(Lsz: integer);
var i: integer;
begin
  Self.Length:=Lsz;//ReadInt();
  For i:=0 to Self.High do
    Self[i].Load(ReadInt());
end;

  procedure RP_T2DAOC (PField: pointer; OP: TFieldOperation; Tind: integer); register;
  var
    o: T2DAOC;
    s: integer;
  begin
    case op of
      fio_Load: begin
                  s:= {$ifdef fpc} CpsStream.ReadDword() {$else} ReadInt() {$endif};
                  if s < 0 then pointer(PField^):=nil
                  else begin
                    T2DAOC(PField^):=T2DAOC.Create;
                    T2DAOC(PField^).Load(s);
                  end;
                end;
      fio_Save: if Assigned(pointer(PField^))
                  then T2DAOC(PField^).Save
                  else WriteNil;
      fio_Skip: begin
                  s:= {$ifdef fpc} CpsStream.ReadDword() {$else} ReadInt() {$endif};
                  if s >= 0 then begin
                    o:=T2DAOC.Create; //load it and destroy it. The fate is cruel.
                    o.Load(s);
                    o.Free;
                  end
                end;
    end;
  end;

function TAOI.Add(i: integer):integer;
begin
  Increment;
  Last:=i;
  Result:=High;
end;

procedure TAOI.ClearMem;
var j: integer;
begin
  For j:=0 to High do
       FillChar(m[j], SizeOf(m[0]), 0);
end;

procedure TAOI._Resize(L: integer);
var j, os: integer;
begin
    SetLength(m, sm);
  os:=s;
  s:=L;
  if L > os then
      For j:=os to L - 1 do FillChar(m[j], SizeOf(m[0]), 0);
end;


function TAOI._Read(ind: cardinal): integer;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'reading from one-dimensional TDyna descendant: invalid index, out of array boundaries');
    Result:=m[ind];
end;

function TAOI._ReadDPTR: pointer;
begin
  if s=0 then Result:=nil else result:=@(m[0]);
end;


function TAOI._ReadLast: integer;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  Result:=m[s-1];
end;

procedure TAOI._Write(ind: cardinal; p: integer);
begin

  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to one-dimensional TDyna descendant: invalid index, out of array boundaries');
  m[ind]:=p;
end;

procedure TAOI._WriteLast(p: integer);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  m[s-1]:=p;
end;

procedure TAOI.Save();
var
  i: integer;
  v: integer;
begin
  {$ifdef fpc} CpsStream.WriteDword( {$else} WriteInt( {$endif}Self.Length);
  For i:=0 to Self.Length - 1 do begin
       v:=Self[i];
       CpsStream.Write(v, 4 * SizeOf(v) div SizeOf(integer));
       Assert(((Sizeof(v) div 4) * 4) = Sizeof(v), 'TDyna should be based on types whose size is multiply of 4')
  end;
end;

procedure TAOI.Load(Lsz: integer);
var
  i: integer;
  v: integer;
begin
  Self.Length:= Lsz;//ReadInt(); //I had to get rid of the PeekInt() function
  For i:=0 to Self.Length - 1 do begin
       CpsStream.Read(v, 4 * SizeOf(v) div sizeof(integer));
       Self[i]:=v;
  end;
end;

function TAOI._ReadNext: integer;
begin
  Assert (CurrentMmb <= Self.High, 'TDyna descendant: reading Next property violated array bondaries.');
  Result:=D[CurrentMmb];
  Inc(CurrentMmb);
end;

function TAOI._ReadFirst: integer;
begin
  Result:=D[0];
  CurrentMmb:=1;
end;

  procedure RP_TAOI (PField: pointer; OP: TFieldOperation; Tind: integer); register;
  var
    o: TAOI;
    s: integer;
  begin
    case op of
      fio_Load: begin
                  s:= {$ifdef fpc} CpsStream.ReadDword() {$else} ReadInt() {$endif};
                  if s < 0 then pointer(PField^):=nil
                  else begin
                    TAOI(PField^):=TAOI.Create;
                    TAOI(PField^).Load(s);
                  end;
                end;
      fio_Save: if Assigned(pointer(PField^))
                  then TAOI(PField^).Save
                  else WriteNil;
      fio_Skip: begin
                  s:={$ifdef fpc} CpsStream.ReadDword() {$else} ReadInt() {$endif};
                  if s >= 0 then begin
                    o:=TAOI.Create; //load it and destroy it. The fate is cruel.
                    o.Load(s);
                    o.Free;
                  end;
                end;
    end;
  end;
function T2DAOI._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of a two-dimensional TDyna descendant');
  Result:=nil;
end;

function T2DAOI._Read(ind: cardinal): TAOI;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind)>=0) and (integer(ind) < s), 'reading from two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  Result:=TAOI(a[ind]);
end;

procedure T2DAOI._Write(ind: cardinal; p: TAOI);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  a[ind]:=pointer(p);
end;

procedure T2DAOI._Resize(L: integer);
var j: integer;
begin
  if L < s then For j:=L to s - 1 do begin TAOI(a[j]).Free; a[j]:=nil end;
  SetLength(a, sm);
  if L > s then For j:=s to L - 1 do a[j]:= pointer(TAOI.Create);
end;

function T2DAOI._ReadLast: TAOI;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Result:=TAOI(a[s-1]);
end;

procedure T2DAOI._WriteLast(z: TAOI);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  a[s - 1]:= pointer(z);
end;

procedure T2DAOI.SetRect(z, b: integer);
var
  x: integer;
begin
  Length:=z;
  For x:=0 to High do D[x].Length:=b;
end;

procedure T2DAOI.ClearMem;
var j: integer;
begin
  For j:=0 to High do D[j].ClearMem;
end;

procedure T2DAOI.Save();
var i: integer;
begin
  {$ifdef fpc} CpsStream.WriteDword( {$else} WriteInt( {$endif}Self.Length);
  For i:=0 to Self.High do
    Self[i].Save;
end;

procedure T2DAOI.Load(Lsz: integer);
var i: integer;
begin
  Self.Length:=Lsz;//ReadInt();
  For i:=0 to Self.High do
    Self[i].Load(ReadInt());
end;
  procedure RP_T2DAOI (PField: pointer; OP: TFieldOperation; Tind: integer); register;
  var
    o: T2DAOI;
    s: integer;
  begin
    case op of
      fio_Load: begin
                  s:= {$ifdef fpc} CpsStream.ReadDword() {$else} ReadInt() {$endif};
                  if s < 0 then pointer(PField^):=nil
                  else begin
                    T2DAOI(PField^):=T2DAOI.Create;
                    T2DAOI(PField^).Load(s);
                  end;
                end;
      fio_Save: if Assigned(pointer(PField^))
                  then T2DAOI(PField^).Save
                  else WriteNil;
      fio_Skip: begin
                  s:= {$ifdef fpc} CpsStream.ReadDword() {$else} ReadInt() {$endif};
                  if s >= 0 then begin
                    o:=T2DAOI.Create; //load it and destroy it. The fate is cruel.
                    o.Load(s);
                    o.Free;
                  end
                end;
    end;
  end;
{ TDyna }

constructor TDyna.Create;
begin
  inherited;
  s:=0;
  sm:=0;
  es:=4;
end;

procedure TDyna.Decrement;
begin
  Assert(s > 0,'attempt to decrement TDyna whose length is zero');
  ReSize(s - 1);
end;

destructor TDyna.Destroy;
begin
  resize(0);
  inherited;
end;

function TDyna.GetHigh: integer;
begin
  Result:=s-1;
end;

function TDyna.GetSize: integer;
begin
  Result:=s;
end;

procedure TDyna.Increment;
begin
  ReSize(s+1);
end;

procedure TDyna.Resize(newLen: integer);
begin
  sm:=NewLen;
  _Resize(NewLen);
  s:=NewLen;
end;

procedure TDYNA.SetRect(a, b: integer);
begin
  Assert(b = 1, 'TDyna: attempt to set second dimension of the one-dimensional array');
  Resize(a);
end;

  Procedure SafeFree(var o: TObject);
  begin
    if Assigned(o) then o.Free;
    pointer(o):=nil;
  end;

function TFieldsList.Add(i: TFieldInfo):integer;
begin
  Increment;
  Last:=i;
  Result:=High;
end;

procedure TFieldsList.ClearMem;
var j: integer;
begin
  For j:=0 to High do
       FillChar(m[j], SizeOf(m[0]), 0);
end;

procedure TFieldsList._Resize(L: integer);
var j, os: integer;
begin
    SetLength(m, sm);
  os:=s;
  s:=L;
  if L > os then
      For j:=os to L - 1 do FillChar(m[j], SizeOf(m[0]), 0);
end;


function TFieldsList._Read(ind: cardinal): TFieldInfo;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'reading from one-dimensional TDyna descendant: invalid index, out of array boundaries');
    Result:=m[ind];
end;

function TFieldsList._ReadDPTR: pointer;
begin
  if s=0 then Result:=nil else result:=@(m[0]);
end;


function TFieldsList._ReadLast: TFieldInfo;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  Result:=m[s-1];
end;

procedure TFieldsList._Write(ind: cardinal; p: TFieldInfo);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to one-dimensional TDyna descendant: invalid index, out of array boundaries');
  m[ind]:=p;
end;

procedure TFieldsList._WriteLast(p: TFieldInfo);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  m[s-1]:=p;
end;

procedure TFieldsList.Save();
var
  i: integer;
  v: TFieldInfo;
begin
//addlog('--saving %0 --', [Ansistring(self.ClassName)]);
  {$ifdef fpc} CpsStream.WriteDword( {$else} WriteInt( {$endif}Self.Length);
  For i:=0 to Self.Length - 1 do begin
       v:=Self[i];
       CpsStream.Write(v, 4 * SizeOf(v) div SizeOf(integer));
       Assert(((Sizeof(v) div 4) * 4) = Sizeof(v), 'TDyna should be based on types whose size is multiply of 4')
  end;
//addLogOk;
end;

procedure TFieldsList.Load(Lsz: integer);
var
  i: integer;
  v: TFieldInfo;
begin
  Self.Length:= Lsz;//ReadInt(); //I had to get rid of the PeekInt() function
  For i:=0 to Self.Length - 1 do begin
       CpsStream.Read(v, 4 * SizeOf(v) div sizeof(integer));
       Self[i]:=v;
  end;
end;

function TFieldsList._ReadNext: TFieldInfo;
begin
  Assert (CurrentMmb <= Self.High, 'TDyna descendant: reading Next property violated array bondaries.');
  Result:=D[CurrentMmb];
  Inc(CurrentMmb);
end;

function TFieldsList._ReadFirst: TFieldInfo;
begin
  Result:=D[0];
  CurrentMmb:=1;
end;

function TFieldInfos._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of a two-dimensional TDyna descendant');
  Result:=nil;
end;

function TFieldInfos._Read(ind: cardinal): TFieldsList;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind)>=0) and (integer(ind) < s), 'reading from two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  Result:=TFieldsList(a[ind]);
end;

procedure TFieldInfos._Write(ind: cardinal; p: TFieldsList);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  a[ind]:=pointer(p);
end;

procedure TFieldInfos._Resize(L: integer);
var j: integer;
begin
  if L < s then For j:=L to s - 1 do begin TFieldsList(a[j]).Free; a[j]:=nil end;
  SetLength(a, sm);
  if L > s then For j:=s to L - 1 do a[j]:= pointer(TFieldsList.Create);
end;

function TFieldInfos._ReadLast: TFieldsList;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Result:=TFieldsList(a[s-1]);
end;

procedure TFieldInfos._WriteLast(z: TFieldsList);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  a[s - 1]:= pointer(z);
end;

procedure TFieldInfos.SetRect(z, b: integer);
var
  x: integer;
begin
  Length:=z;
  For x:=0 to High do D[x].Length:=b;
end;

procedure TFieldInfos.ClearMem;
var j: integer;
begin
  For j:=0 to High do D[j].ClearMem;
end;

procedure TFieldInfos.Save();
var i: integer;
begin
  {$ifdef fpc} CpsStream.WriteDword( {$else} WriteInt( {$endif}Self.Length);
  For i:=0 to Self.High do
    Self[i].Save;
end;

procedure TFieldInfos.Load(Lsz: integer);
var i: integer;
begin
  Self.Length:=Lsz;//ReadInt();
  For i:=0 to Self.High do
    Self[i].Load(ReadInt());
end;


function TAOMO.Add(i: TManagedObject):integer;
begin
  Increment;
  Last:=i;
  Result:=High;
end;

procedure TAOMO.ClearMem;
var j: integer;
begin
  For j:=0 to High do
    begin
      if Container then SafeFree(TObject(a[j]));
      a[j]:= NIL;
    end;
end;

procedure TAOMO._Resize(L: integer);
var j, os: integer;
begin
    if (L < s) and Container then For j:=L to s - 1 do begin
      if Assigned(D[j]) then begin
        D[j].Free;
        a[j]:=nil;// pointer(D[j]):=nil;
      end;
    end;
    SetLength(a, sm);
  os:=s;
  s:=L;
  if L > os then
    For j:=os to L - 1 do D[j]:= NIL;
end;


function TAOMO._Read(ind: cardinal): TManagedObject;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'reading from one-dimensional TDyna descendant: invalid index, out of array boundaries');
    Result:=TManagedObject(a[ind]);
end;

function TAOMO._ReadDPTR: pointer;
begin
  if s=0 then Result:=nil else result:=@(a[0]);
end;


function TAOMO._ReadLast: TManagedObject;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  Result:= TManagedObject(a[s-1]);
end;

procedure TAOMO._Write(ind: cardinal; p: TManagedObject);
begin

  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to one-dimensional TDyna descendant: invalid index, out of array boundaries');
  a[ind]:=pointer(p);
end;

procedure TAOMO._WriteLast(p: TManagedObject);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  a[s-1]:=pointer(p);
end;

procedure TAOMO.Save();
var
  i: integer;
begin
  {$ifdef fpc} CpsStream.WriteDword( {$else} WriteInt( {$endif}Self.Length);
  For i:=0 to Self.Length - 1 do begin
      WritePersistent((Self[i]) as TManagedObject);
  end;
end;

procedure TAOMO.Load(Lsz: integer);
var
  i: integer;
  v: TManagedObject;
begin
  Self.Length:= Lsz;//ReadInt(); //I had to get rid of the PeekInt() function
  For i:=0 to Self.Length - 1 do begin
       ReadPersistent(TManagedObject(v));
       Self[i]:= v;
  end;
end;

function TAOMO._ReadNext: TManagedObject;
begin
  Assert (CurrentMmb <= Self.High, 'TDyna descendant: reading Next property violated array bondaries.');
  Result:=D[CurrentMmb];
  Inc(CurrentMmb);
end;

function TAOMO._ReadFirst: TManagedObject;
begin
  Result:=D[0];
  CurrentMmb:=1;
end;

function TArrayOfDyna.Add(i: TDyna):integer;
begin
  Increment;
  Last:=i;
  Result:=High;
end;

procedure TArrayOfDyna.ClearMem;
var j: integer;
begin
  For j:=0 to High do
    begin
      if Container then SafeFree(TObject(a[j]));
      a[j]:= NIL;
    end;
end;

procedure TArrayOfDyna._Resize(L: integer);
var j, os: integer;
begin
    if (L < s) and Container then For j:=L to s - 1 do begin
      if Assigned(D[j]) then begin
        D[j].Free;
        a[j]:=nil;// pointer(D[j]):=nil;
      end;
    end;
    SetLength(a, sm);
  os:=s;
  s:=L;
  if L > os then
    For j:=os to L - 1 do D[j]:= NIL;
end;


function TArrayOfDyna._Read(ind: cardinal): TDyna;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'reading from one-dimensional TDyna descendant: invalid index, out of array boundaries');
    Result:=TDyna(a[ind]);
end;

function TArrayOfDyna._ReadDPTR: pointer;
begin
  if s=0 then Result:=nil else result:=@(a[0]);
end;


function TArrayOfDyna._ReadLast: TDyna;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  Result:= TDyna(a[s-1]);
end;

procedure TArrayOfDyna._Write(ind: cardinal; p: TDyna);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to one-dimensional TDyna descendant: invalid index, out of array boundaries');
  a[ind]:=pointer(p);
end;

procedure TArrayOfDyna._WriteLast(p: TDyna);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  a[s-1]:=pointer(p);
end;

procedure TArrayOfDyna.Save();
var
  i: integer;
begin
  {$ifdef fpc} CpsStream.WriteDword( {$else} WriteInt( {$endif}Self.Length);
  For i:=0 to Self.Length - 1 do begin
      if Assigned(Self[i])
        then (Self[i] as TDyna).Save
        else WriteNil;
  end;
end;

procedure TArrayOfDyna.Load(Lsz: integer);
var
  Ls,i: integer;
  v: TDyna;
begin
  Self.Length:= Lsz;//ReadInt(); //I had to get rid of the PeekInt() function
  For i:=0 to Self.Length - 1 do begin
      //TDyna descendant.
       Ls:= {$ifdef fpc} CpsStream.ReadDword() {$else} ReadInt() {$endif};
       if Ls < 0 then Self[i]:=nil
         {The Dynas always write their length first.
          thus, this value cannot be negative for an existing object.}
       else begin
         Self[i]:= TDyna.Create;
         (Self[i] as TDyna).Load(Ls);
       end;
  end;
end;

function TArrayOfDyna._ReadNext: TDyna;
begin
  Assert (CurrentMmb <= Self.High, 'TDyna descendant: reading Next property violated array bondaries.');
  Result:=D[CurrentMmb];
  Inc(CurrentMmb);
end;

function TArrayOfDyna._ReadFirst: TDyna;
begin
  Result:=D[0];
  CurrentMmb:=1;
end;


function TTypeRegistry.Add(i: TTypeRecord):integer;
begin
  Increment;
  Last:=i;
  Result:=High;
end;

procedure TTypeRegistry.ClearMem;
var j: integer;
begin
  For j:=0 to High do
       FillChar(m[j], SizeOf(m[0]), 0);
end;

procedure TTypeRegistry._Resize(L: integer);
var j, os: integer;
begin
    SetLength(m, sm);
  os:=s;
  s:=L;
  if L > os then
      For j:=os to L - 1 do FillChar(m[j], SizeOf(m[0]), 0);
end;


function TTypeRegistry._Read(ind: cardinal): TTypeRecord;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
//verboselogA(Self.ClassName + '  %0  %1', [ind, Self.High]);
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'reading from one-dimensional TDyna descendant: invalid index, out of array boundaries');
    Result:=m[ind];
end;

function TTypeRegistry._ReadDPTR: pointer;
begin
  if s=0 then Result:=nil else result:=@(m[0]);
end;


function TTypeRegistry._ReadLast: TTypeRecord;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  Result:=m[s-1];
end;

procedure TTypeRegistry._Write(ind: cardinal; p: TTypeRecord);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to one-dimensional TDyna descendant: invalid index, out of array boundaries');
  m[ind]:=p;
end;

procedure TTypeRegistry._WriteLast(p: TTypeRecord);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  m[s-1]:=p;
end;

procedure TTypeRegistry.Save();
var
  i: integer;
  v: TTypeRecord;
begin
  {$ifdef fpc} CpsStream.WriteDword( {$else} WriteInt( {$endif}Self.Length);
  For i:=0 to Self.Length - 1 do begin
       v:=Self[i];
       CpsStream.Write(v, 4 * SizeOf(v) div SizeOf(integer));
       Assert(((Sizeof(v) div 4) * 4) = Sizeof(v), 'TDyna should be based on types whose size is multiply of 4')
  end;
end;

procedure TTypeRegistry.Load(Lsz: integer);
var
  i: integer;
  v: TTypeRecord;
begin
  Self.Length:= Lsz;//ReadInt(); //I had to get rid of the PeekInt() function
  For i:=0 to Self.Length - 1 do begin
       CpsStream.Read(v, 4 * SizeOf(v) div sizeof(integer));
       Self[i]:=v;
  end;
end;

function TTypeRegistry._ReadNext: TTypeRecord;
begin
  Assert (CurrentMmb <= Self.High, 'TDyna descendant: reading Next property violated array bondaries.');
  Result:=D[CurrentMmb];
  Inc(CurrentMmb);
end;

function TTypeRegistry._ReadFirst: TTypeRecord;
begin
  Result:=D[0];
  CurrentMmb:=1;
end;


  procedure RP_TAOMO (PField: pointer; OP: TFieldOperation; Tind: integer); register;
  var
    o: TAOMO;
    s: integer;
  begin
    case op of
      fio_Load: begin
                  s:= {$ifdef fpc} CpsStream.ReadDword() {$else} ReadInt() {$endif};
                  if s < 0 then pointer(PField^):=nil
                  else begin
                    TAOMO(PField^):=TAOMO.Create;
                    TAOMO(PField^).Load(s);
                  end;
                end;
      fio_Save: if Assigned(pointer(PField^))
                  then TAOMO(PField^).Save
                  else WriteNil;
      fio_Skip: begin
                  s:={$ifdef fpc} CpsStream.ReadDword() {$else} ReadInt() {$endif};
                  if s >= 0 then begin
                    o:=TAOMO.Create; //load it and destroy it. The fate is cruel.
                    o.Load(s);
                    o.Free;
                  end;
                end;
      fio_Walk: begin
                  for s:=0 to TAOMO(PField^).High do
                    WalkPersistent(TManagedObject(TAOMO(PField^)[s]))
                end;

    end;
  end;


  procedure RP_TArrayOfDyna (PField: pointer; OP: TFieldOperation; Tind: integer); register;
  var
    o: TArrayOfDyna;
    s, i: integer;
  begin
    case op of
      fio_Load: begin
                  s:= {$ifdef fpc} CpsStream.ReadDword() {$else} ReadInt() {$endif};
                  if s < 0 then pointer(PField^):=nil
                  else begin
                    TArrayOfDyna(PField^):=TArrayOfDyna.Create;
                    TArrayOfDyna(PField^).Load(s);
                  end;
                end;
      fio_Save: if Assigned(pointer(PField^))
                  then TArrayOfDyna(PField^).Save
                  else WriteNil;
      fio_Skip: begin
                  s:={$ifdef fpc} CpsStream.ReadDword() {$else} ReadInt() {$endif};
                  if s >= 0 then begin
                    o:=TArrayOfDyna.Create; //load it and destroy it. The fate is cruel.
                    o.Load(s);
                    o.Free;
                  end;
                end;
      fio_Walk: begin
                  with TArrayOfDyna(PField^) do
                    For i:=0 to High do
                      if Assigned(D[i]) and (D[i] is TAOMO)
                        then RP_TAOMO(pointer(cardinal(DPTR) + i*4), fio_Walk, 0);
                end;
    end;
  end;

