{
    This file is part of Chentrah,
    Copyright (C) 2004-2008 Anton Rzheshevski (chebmaster@mail.ru).

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/

 **********************************************************************

    This file  contains the game world framework class.

 **********************************************************************}
{$ifdef fpc}
  {$mode delphi}
{$endif}
{$longstrings on}
{$minenumsize 4}

unit mo_game;

interface
uses
  mo_hub, chepersy, { mo_indexer,} mo_gamerender;
  
Const
  MaxGameTickTime = 0.1; //10Hz

type
  TGame = class(TTrulyPersistent)
  protected
    GRender: TAbstractGameRender;
  public
//    ObInd: TIndexer;
    procedure RegisterFields; override;
    procedure AfterLoading; override;
    procedure BeforeSaving; override;
    
    procedure Cycle(TimePassed: float); virtual;
    function Render: boolean; virtual;
    procedure OnResize; virtual;
  end;

implementation

  procedure TGame.RegisterFields;
  begin
    RegClass(TAbstractGameRender);
//    RegClass(TIndexer);
    inherited;
    ListFields([
      'GRender', @GRender, TypeInfo(TAbstractGameRender)
//      ,'ObjectIndex', @ObInd, TypeInfo(TIndexer)
     ]);
  end;

  procedure TGame.AfterLoading;
  begin

  end;

  procedure TGame.BeforeSaving;
  begin

  end;
  
  procedure TGame.Cycle(TimePassed: float);
  begin
    if TimePassed > MaxGameTickTime
      then Cycle(TimePassed - MaxGameTickTime);
  end;

  function TGame.Render: boolean;
  begin
    if assigned(GRender) then
      Result:=GRender.Execute
    else
      Result:=False;
  end;
  
  procedure TGame.OnResize;
  begin

  end;
  

end.
