{
    This file is part of Chentrah,
    Copyright (C) 2004-2014 Anton Rzheshevski (chebmaster@mail.ru).

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/

 **********************************************************************}

unit mo_gmathbase;

interface

uses
  sysutils, Classes, math, md5, chepersy, mo_hub, typinfo;


{$ifdef dosmath}
 type
  ffloat = float; // no multiplayer here, d'uh.
 const
  FF_ZERO: float = 0.0;
{$else}
  //Windows
  {$ifdef fixedmath}  //multiplayer
    type
      ffloat = fixed32; //deterministic but inefficient
    const
     FF_ZERO: fixed32 = (i: 0);
  {$else}
    type
      ffloat = float; //efficient but non-deterministic
    const
     FF_ZERO: float = 0.0;

  {$endif}
{$endif}

 type
   TffVector = packed record
     x, y, z: ffloat;
   end;

  procedure RegisterGMathBaseTypes;
  function ValidateTextureDimension(i: GLint): GLint;
  function Validate3dTextureDimension(i: GLint): GLint;

implementation

procedure RegisterGMathBaseTypes;
begin
  RegType(typeinfo(TffVector), sizeof(TffVector), ['x', 'y', 'z', typeinfo(ffloat)]);

end;

function ValidateTextureDimension(i: GLint): GLint;
begin
  if (MotherState^.OGLNpotSupported)
    then Result:= max(1, min(i, MotherState^.OGLTextureMax))
    else Result:= max(1, min(GetHigherPowerOf2(i), MotherState^.OGLTextureMax));
end;

function Validate3dTextureDimension(i: GLint): GLint;
begin
  if (MotherState^.OGLNpotSupported)
    then Result:= max(1, min(i, MotherState^.OGL3dTextureMax))
    else Result:= max(1, min(GetHigherPowerOf2(i), MotherState^.OGL3dTextureMax));
end;


end.
