
type
  TKey = (
    KEY_NULL, //represents the mouse motion event.
    KEY_ESCAPE,//        = 1;
    KEY_1,//             = 2;
    KEY_2,//             = 3;
    KEY_3,//             = 4;
    KEY_4,//             = 5;
    KEY_5,//             = 6;
    KEY_6,//             = 7;
    KEY_7,//             = 8;
    KEY_8,//             = 9;
    KEY_9,//             = 10;
    KEY_0,//             = 11;
    KEY_MINUS,//         = 12;
    KEY_EQUALS,//        = 13;
    KEY_BACKSPACE,//     = 14;
    KEY_TAB,//           = 15;
    KEY_Q,//             = $10;
    KEY_W,//             = $11;
    KEY_E,//             = $12;
    KEY_R,//             = $13;
    KEY_T,//             = $14;
    KEY_Y,//             = $15;
    KEY_U,//             = $16;
    KEY_I,//             = $17;
    KEY_O,//             = $18;
    KEY_P,//             = $19;
    KEY_LEFT_BRACKET,//  = $1A;
    KEY_RIGHT_BRACKET,// = $1B;
    KEY_ENTER,//         = $1C;
    KEY_LEFT_CTRL,//     = $1D;
    KEY_A,//             = $1E;
    KEY_S,//             = $1F;
    KEY_D,//             = $20;
    KEY_F,//             = $21;
    KEY_G,//             = $22;
    KEY_H,//             = $23;
    KEY_J,//             = $24;
    KEY_K,//             = $25;
    KEY_L,//             = $26;
    KEY_SEMICOLON,//     = $27;
    KEY_APOSTROPHE,//    = $28;
    KEY_GRAVE,//         = $29;
    KEY_LEFT_SHIFT,//    = $2A;
    KEY_BACKSLASH,//     = $2B;
    KEY_Z,//             = $2C;
    KEY_X,//             = $2D;
    KEY_C,//             = $2E;
    KEY_V,//             = $2F;
    KEY_B,//             = $30;
    KEY_N,//             = $31;
    KEY_M,//             = $32;
    KEY_COMMA,//         = $33;
    KEY_PERIOD,//        = $34;
    KEY_SLASH,//         = $35;
    KEY_RIGHT_SHIFT,//        = $36;
    KEY_KP_STAR,//       = $37;
    KEY_LEFT_ALT,//      = $38;
    KEY_SPACE,//         = $39;
    KEY_CAPS_LOCK,//     = $3A;
    KEY_F1,//            = $3B;
    KEY_F2,//            = $3C;
    KEY_F3,//            = $3D;
    KEY_F4,//            = $3E;
    KEY_F5,//            = $3F;
    KEY_F6,//            = $40;
    KEY_F7,//            = $41;
    KEY_F8,//            = $42;
    KEY_F9,//            = $43;
    KEY_F10,//           = $44;
    KEY_PAUSE,   //      = $45;
    KEY_SCROLL_LOCK,//   = $46;
    KEY_KP_7,//          = $47;
    KEY_KP_8,//          = $48;
    KEY_KP_9,//          = $49;
    KEY_KP_MINUS,//      = $4A;
    KEY_KP_4,//          = $4B;
    KEY_KP_5,//          = $4C;
    KEY_KP_6,//          = $4D;
    KEY_KP_PLUS,//       = $4E;
    KEY_KP_1,//          = $4F;
    KEY_KP_2,//          = $50;
    KEY_KP_3,//          = $51;
    KEY_KP_0,//          = $52;
    KEY_KP_DECIMAL,//    = $53;

    KEY_NONAME_54h,
    KEY_NONAME_55h,

    KEY_OEM_102,//       = $56;
    KEY_F11,//           = $57;
    KEY_F12,//           = $58;

    KEY_NONAME_59h,
    KEY_NONAME_5Ah,
    KEY_NONAME_5Bh,
    KEY_NONAME_5Ch,
    KEY_NONAME_5Dh,
    KEY_NONAME_5Eh,
    KEY_NONAME_5Fh,
    KEY_NONAME_60h,
    KEY_NONAME_61h,
    KEY_NONAME_62h,
    KEY_NONAME_63h,

    KEY_F13,//           = $64;
    KEY_F14,//           = $65;
    KEY_F15,//           = $66;

    KEY_NONAME_67h,
    KEY_NONAME_68h,
    KEY_NONAME_69h,
    KEY_NONAME_6Ah,
    KEY_NONAME_6Bh,
    KEY_NONAME_6Ch,
    KEY_NONAME_6Dh,
    KEY_NONAME_6Eh,
    KEY_NONAME_6Fh,

    KEY_NONAME_70h,
    KEY_NONAME_71h,
    KEY_NONAME_72h,
    KEY_NONAME_73h,
    KEY_NONAME_74h,
    KEY_NONAME_75h,
    KEY_NONAME_76h,
    KEY_NONAME_77h,
    KEY_NONAME_78h,
    KEY_NONAME_79h,
    KEY_NONAME_7Ah,
    KEY_NONAME_7Bh,
    KEY_NONAME_7Ch,
    KEY_NONAME_7Dh,
    KEY_NONAME_7Eh,
    KEY_NONAME_7Fh,

    KEY_NONAME_80h,
    KEY_NONAME_81h,
    KEY_NONAME_82h,
    KEY_NONAME_83h,
    KEY_NONAME_84h,
    KEY_NONAME_85h,
    KEY_NONAME_86h,
    KEY_NONAME_87h,
    KEY_NONAME_88h,
    KEY_NONAME_89h,
    KEY_NONAME_8Ah,
    KEY_NONAME_8Bh,
    KEY_NONAME_8Ch,
    KEY_NONAME_8Dh,
    KEY_NONAME_8Eh,
    KEY_NONAME_8Fh,

    KEY_NONAME_90h,
    KEY_NONAME_91h,
    KEY_NONAME_92h,
    KEY_NONAME_93h,
    KEY_NONAME_94h,
    KEY_NONAME_95h,
    KEY_NONAME_96h,
    KEY_NONAME_97h,
    KEY_NONAME_98h,
    KEY_NONAME_99h,
    KEY_NONAME_9Ah,
    KEY_NONAME_9Bh,

    KEY_KP_ENTER,//      = $9C;
    KEY_RIGHT_CTRL,//    = $9D;

    KEY_NONAME_9Eh,
    KEY_NONAME_9Fh,

    KEY_NONAME_A0h,
    KEY_NONAME_A1h,
    KEY_NONAME_A2h,
    KEY_NONAME_A3h,
    KEY_NONAME_A4h,
    KEY_NONAME_A5h,
    KEY_NONAME_A6h,
    KEY_NONAME_A7h,
    KEY_NONAME_A8h,
    KEY_NONAME_A9h,
    KEY_NONAME_AAh,
    KEY_NONAME_ABh,
    KEY_NONAME_ACh,
    KEY_NONAME_ADh,
    KEY_NONAME_AEh,
    KEY_NONAME_AFh,

    KEY_NONAME_B0h,
    KEY_NONAME_B1h,
    KEY_NONAME_B2h,
    KEY_NONAME_B3h,
    KEY_NONAME_B4h,

    KEY_KP_DIVIDE,//     = $B5;

    KEY_NONAME_B6h,

    KEY_SYSRQ,//         = $B7;
    KEY_RIGHT_ALT,//     = $B8;

    KEY_NONAME_B9h,
    KEY_NONAME_BAh,
    KEY_NONAME_BBh,
    KEY_NONAME_BCh,
    KEY_NONAME_BDh,
    KEY_NONAME_BEh,
    KEY_NONAME_BFh,

    KEY_NONAME_C0h,
    KEY_NONAME_C1h,
    KEY_NONAME_C2h,
    KEY_NONAME_C3h,
    KEY_NONAME_C4h,

    KEY_NUM_LOCK,//      = $C5;

    KEY_NONAME_C6h,

    KEY_HOME,//          = $C7;
    KEY_UP,//            = $C8;
    KEY_PGUP,//          = $C9;

    KEY_NONAME_CAh,

    KEY_LEFT,//          = $CB;

    KEY_NONAME_CCh,

    KEY_RIGHT,//         = $CD;

    KEY_NONAME_CEh,

    KEY_END,//           = $CF;
    KEY_DOWN,//          = $D0;
    KEY_PGDN,//          = $D1;
    KEY_INSERT,//        = $D2;
    KEY_DELETE,//        = $D3;

    KEY_NONAME_D4h,
    KEY_NONAME_D5h,
    KEY_NONAME_D6h,
    KEY_NONAME_D7h,
    KEY_NONAME_D8h,
    KEY_NONAME_D9h,
    KEY_NONAME_DAh,

    KEY_LEFT_WINDOWS,//  = $DB;
    KEY_RIGHT_WINDOWS,// = $DC;
    KEY_APP_MENU,//      = $DD;
    KEY_POWER,//         = $DE;
    KEY_SLEEP,//         = $DF;

    KEY_NONAME_E0h,
    KEY_NONAME_E1h,
    KEY_NONAME_E2h,

    KEY_WAKE,//          = $E3;

    KEY_NONAME_E4h,
    KEY_NONAME_E5h,
    KEY_NONAME_E6h,
    KEY_NONAME_E7h,
    KEY_NONAME_E8h,
    KEY_NONAME_E9h,
    KEY_GAMEPAD_LEFT_TRIGGER, //KEY_NONAME_EAh,
    KEY_GAMEPAD_RIGHT_TRIGGER, //KEY_NONAME_EBh,

    KEY_GAMEPAD_DPAD_UP, //     KEY_NONAME_ECh,
    KEY_GAMEPAD_DPAD_DOWN, //      KEY_NONAME_EDh,
    KEY_GAMEPAD_DPAD_LEFT, //       KEY_NONAME_EEh,
    KEY_GAMEPAD_DPAD_RIGHT, //       KEY_NONAME_EFh,
    KEY_GAMEPAD_START, //        KEY_NONAME_F0h,
    KEY_GAMEPAD_BACK, //       KEY_NONAME_F1h,
    KEY_GAMEPAD_LEFT_THUMB, //        KEY_NONAME_F2h,
    KEY_GAMEPAD_RIGHT_THUMB, //         KEY_NONAME_F3h,
    KEY_GAMEPAD_LEFT_SHOULDER, //       KEY_NONAME_F4h,
    KEY_GAMEPAD_RIGHT_SHOULDER, //       KEY_NONAME_F5h,
    KEY_GAMEPAD_A, //        KEY_NONAME_F6h,
    KEY_GAMEPAD_B, //        KEY_NONAME_F7h,
    KEY_GAMEPAD_X, //       KEY_NONAME_F8h,
    KEY_GAMEPAD_Y, //       KEY_NONAME_F9h,

    KEY_TABLET_PEN_ACTION, //KEY_NONAME_FAh,

    KEY_MWHEEL_DOWN,//   = $FB;
    KEY_MWHEEL_UP,//     = $FC;
    KEY_MOUSE_MIDDLE,//  = $FD;
    KEY_MOUSE_RIGHT,//   = $FE;
    KEY_MOUSE_LEFT//    = $FF;
  );

  TKeySet = set of TKey;
  TKeySetArray = array of TKeySet;

const
  KeysWorkingInTextInputMode: TKeySet  = [
    KEY_NULL, KEY_ESCAPE, KEY_BACKSPACE, KEY_TAB, KEY_ENTER,
    KEY_LEFT_CTRL, KEY_LEFT_ALT, KEY_CAPS_LOCK,
    KEY_F1,  KEY_F2, KEY_F3, KEY_F4, KEY_F5, KEY_F6, KEY_F7, KEY_F8, KEY_F9, KEY_F10, KEY_F11, KEY_F12,  KEY_F13, KEY_F14, KEY_F15,
    KEY_NUM_LOCK, KEY_SCROLL_LOCK, KEY_KP_8, KEY_KP_4, KEY_KP_6, KEY_KP_2,
    KEY_KP_0, KEY_KP_DECIMAL,

    KEY_KP_ENTER,  KEY_RIGHT_CTRL,
    KEY_SYSRQ,  KEY_RIGHT_ALT,  KEY_PAUSE,
    KEY_NONAME_C6h,
    KEY_HOME, KEY_UP, KEY_PGUP, KEY_LEFT,  KEY_RIGHT,
    KEY_END,  KEY_DOWN,   KEY_PGDN,
    KEY_INSERT,  KEY_DELETE,
    KEY_LEFT_WINDOWS,  KEY_RIGHT_WINDOWS,  KEY_APP_MENU, KEY_POWER,  KEY_SLEEP,  KEY_WAKE,
    KEY_MWHEEL_DOWN,
    KEY_MWHEEL_UP,  KEY_MOUSE_MIDDLE,
    KEY_MOUSE_RIGHT,
    KEY_MOUSE_LEFT,

    KEY_GAMEPAD_LEFT_TRIGGER, KEY_GAMEPAD_RIGHT_TRIGGER, KEY_GAMEPAD_DPAD_UP, KEY_GAMEPAD_DPAD_DOWN, KEY_GAMEPAD_DPAD_LEFT, KEY_GAMEPAD_DPAD_RIGHT, KEY_GAMEPAD_START,
    KEY_GAMEPAD_BACK,     KEY_GAMEPAD_LEFT_THUMB,    KEY_GAMEPAD_RIGHT_THUMB,     KEY_GAMEPAD_LEFT_SHOULDER,     KEY_GAMEPAD_RIGHT_SHOULDER,    KEY_GAMEPAD_A,
    KEY_GAMEPAD_B, KEY_GAMEPAD_X, KEY_GAMEPAD_Y,

    KEY_TABLET_PEN_ACTION
  ];

  KeysAcceptingAutoRepeatInTextInputMode: TKeySet  = [
    KEY_DELETE, KEY_BACKSPACE, KEY_PGUP, KEY_PGDN,
    KEY_UP, KEY_DOWN, KEY_LEFT,  KEY_RIGHT
  ];

  KeyNames: array[TKey, 0..1] of WideString = (
    ('движение мыши','mouse movement'),//KEY_NULL, //represents the mouse motion event.
    ('','Esc'),//KEY_ESCAPE,//        = 1;
    ('','1'),//KEY_1,//             = 2;
    ('','2'),//KEY_2,//             = 3;
    ('','3'),//KEY_3,//             = 4;
    ('','4'),//KEY_4,//             = 5;
    ('','5'),//KEY_5,//             = 6;
    ('','6'),//KEY_6,//             = 7;
    ('','7'),//KEY_7,//             = 8;
    ('','8'),//KEY_8,//             = 9;
    ('','9'),//KEY_9,//             = 10;
    ('','0'),//KEY_0,//             = 11;
    ('','-'),//KEY_MINUS,//         = 12;
    ('','+'),//KEY_EQUALS,//        = 13;
    ('','Backspace'),//KEY_BACKSPACE,//     = 14;
    ('','Tab'),//KEY_TAB,//           = 15;
    ('Й','Q'),//KEY_Q,//             = $10;
    ('Ц','W'),//KEY_W,//             = $11;
    ('У','E'),//KEY_E,//             = $12;
    ('К','R'),//KEY_R,//             = $13;
    ('Е','T'),//KEY_T,//             = $14;
    ('Н','Y'),//KEY_Y,//             = $15;
    ('Г','U'),//KEY_U,//             = $16;
    ('Ш','I'),//KEY_I,//             = $17;
    ('Щ','O'),//KEY_O,//             = $18;
    ('З','P'),//KEY_P,//             = $19;
    ('Х','['),//KEY_LEFT_BRACKET,//  = $1A;
    ('Ъ',']'),//KEY_RIGHT_BRACKET,// = $1B;
    ('','Enter'),//KEY_ENTER,//         = $1C;
    ('Левый Control','Left Control'),//KEY_LEFT_CTRL,//     = $1D;
    ('Ф','A'),//KEY_A,//             = $1E;
    ('Ы','S'),//KEY_S,//             = $1F;
    ('В','D'),//KEY_D,//             = $20;
    ('А','F'),//KEY_F,//             = $21;
    ('П','G'),//KEY_G,//             = $22;
    ('Р','H'),//KEY_H,//             = $23;
    ('О','J'),//KEY_J,//             = $24;
    ('Л','K'),//KEY_K,//             = $25;
    ('Д','L'),//KEY_L,//             = $26;
    ('Ж',';'),//KEY_SEMICOLON,//     = $27;
    ('Э',''''),//KEY_APOSTROPHE,//    = $28;
    ('Ё','~'),//KEY_GRAVE,//         = $29;
    ('Левый Shift','Left Shift'),//KEY_LEFT_SHIFT,//    = $2A;
    ('','\'),//KEY_BACKSLASH,//     = $2B;
    ('Я','Z'),//KEY_Z,//             = $2C;
    ('Ч','X'),//KEY_X,//             = $2D;
    ('С','C'),//KEY_C,//             = $2E;
    ('М','V'),//KEY_V,//             = $2F;
    ('И','B'),//KEY_B,//             = $30;
    ('Т','N'),//KEY_N,//             = $31;
    ('Ь','M'),//KEY_M,//             = $32;
    ('Б',','),//KEY_COMMA,//         = $33;
    ('Ю','.'),//KEY_PERIOD,//        = $34;
    ('.','/'),//KEY_SLASH,//         = $35;
    ('Правый Shift','Right Shift'),//KEY_RIGHT_SHIFT,//        = $36;
    ('','*'),//KEY_KP_STAR,//       = $37;
    ('Левый Alt','Left Alt'),//KEY_LEFT_ALT,//      = $38;
    ('Пробел','Space Bar'),//KEY_SPACE,//         = $39;
    ('','Caps Lock'),//KEY_CAPS_LOCK,//     = $3A;
    ('','F1'),//KEY_F1,//            = $3B;
    ('','F2'),//KEY_F2,//            = $3C;
    ('','F3'),//KEY_F3,//            = $3D;
    ('','F4'),//KEY_F4,//            = $3E;
    ('','F5'),//KEY_F5,//            = $3F;
    ('','F6'),//KEY_F6,//            = $40;
    ('','F7'),//KEY_F7,//            = $41;
    ('','F8'),//KEY_F8,//            = $42;
    ('','F9'),//KEY_F9,//            = $43;
    ('','F10'),//KEY_F10,//           = $44;
    ('','Pause/Break'),//KEY_PAUSE,   //      = $45;
    ('','Scroll Lock'),//KEY_SCROLL_LOCK,//   = $46;
    ('7 на кейпаде','Keypad 7'),//KEY_KP_7,//          = $47;
    ('8 на кейпаде','Keypad 8'),//KEY_KP_8,//          = $48;
    ('9 на кейпаде','Keypad 9'),//KEY_KP_9,//          = $49;
    ('- на кейпаде','Keypad -'),//KEY_KP_MINUS,//      = $4A;
    ('4 на кейпаде','Keypad 4'),//KEY_KP_4,//          = $4B;
    ('5 на кейпаде','Keypad 5'),//KEY_KP_5,//          = $4C;
    ('6 на кейпаде','Keypad 6'),//KEY_KP_6,//          = $4D;
    ('+ на кейпаде','Keypad +'),//KEY_KP_PLUS,//       = $4E;
    ('1 на кейпаде','Keypad 1'),//KEY_KP_1,//          = $4F;
    ('2 на кейпаде','Keypad 2'),//KEY_KP_2,//          = $50;
    ('3 на кейпаде','Keypad 3'),//KEY_KP_3,//          = $51;
    ('0 на кейпаде','Keypad 0'),//KEY_KP_0,//          = $52;
    ('. на кейпаде','Keypad .'),//KEY_KP_DECIMAL,//    = $53;

    ('',''),//KEY_NONAME_54h,
    ('',''),//KEY_NONAME_55h,

    ('',''),//KEY_OEM_102,//       = $56;
    ('','F11'),//KEY_F11,//           = $57;
    ('','F12'),//KEY_F12,//           = $58;

    ('',''),//KEY_NONAME_59h,
    ('',''),//KEY_NONAME_5Ah,
    ('',''),//KEY_NONAME_5Bh,
    ('',''),//KEY_NONAME_5Ch,
    ('',''),//KEY_NONAME_5Dh,
    ('',''),//KEY_NONAME_5Eh,
    ('',''),//KEY_NONAME_5Fh,
    ('',''),//KEY_NONAME_60h,
    ('',''),//KEY_NONAME_61h,
    ('',''),//KEY_NONAME_62h,
    ('',''),//KEY_NONAME_63h,

    ('','F13'),//KEY_F13,//           = $64;
    ('','F14'),//KEY_F14,//           = $65;
    ('','F15'),//KEY_F15,//           = $66;

    ('',''),//KEY_NONAME_67h,
    ('',''),//KEY_NONAME_68h,
    ('',''),//KEY_NONAME_69h,
    ('',''),//KEY_NONAME_6Ah,
    ('',''),//KEY_NONAME_6Bh,
    ('',''),//KEY_NONAME_6Ch,
    ('',''),//KEY_NONAME_6Dh,
    ('',''),//KEY_NONAME_6Eh,
    ('',''),//KEY_NONAME_6Fh,

    ('',''),//KEY_NONAME_70h,
    ('',''),//KEY_NONAME_71h,
    ('',''),//KEY_NONAME_72h,
    ('',''),//KEY_NONAME_73h,
    ('',''),//KEY_NONAME_74h,
    ('',''),//KEY_NONAME_75h,
    ('',''),//KEY_NONAME_76h,
    ('',''),//KEY_NONAME_77h,
    ('',''),//KEY_NONAME_78h,
    ('',''),//KEY_NONAME_79h,
    ('',''),//KEY_NONAME_7Ah,
    ('',''),//KEY_NONAME_7Bh,
    ('',''),//KEY_NONAME_7Ch,
    ('',''),//KEY_NONAME_7Dh,
    ('',''),//KEY_NONAME_7Eh,
    ('',''),//KEY_NONAME_7Fh,

    ('',''),//KEY_NONAME_80h,
    ('',''),//KEY_NONAME_81h,
    ('',''),//KEY_NONAME_82h,
    ('',''),//KEY_NONAME_83h,
    ('',''),//KEY_NONAME_84h,
    ('',''),//KEY_NONAME_85h,
    ('',''),//KEY_NONAME_86h,
    ('',''),//KEY_NONAME_87h,
    ('',''),//KEY_NONAME_88h,
    ('',''),//KEY_NONAME_89h,
    ('',''),//KEY_NONAME_8Ah,
    ('',''),//KEY_NONAME_8Bh,
    ('',''),//KEY_NONAME_8Ch,
    ('',''),//KEY_NONAME_8Dh,
    ('',''),//KEY_NONAME_8Eh,
    ('',''),//KEY_NONAME_8Fh,

    ('',''),//KEY_NONAME_90h,
    ('',''),//KEY_NONAME_91h,
    ('',''),//KEY_NONAME_92h,
    ('',''),//KEY_NONAME_93h,
    ('',''),//KEY_NONAME_94h,
    ('',''),//KEY_NONAME_95h,
    ('',''),//KEY_NONAME_96h,
    ('',''),//KEY_NONAME_97h,
    ('',''),//KEY_NONAME_98h,
    ('',''),//KEY_NONAME_99h,
    ('',''),//KEY_NONAME_9Ah,
    ('',''),//KEY_NONAME_9Bh,

    ('Enter на кейпаде','Keypad Enter'),//KEY_KP_ENTER,//      = $9C;
    ('Правый Control','Right Control'),//KEY_RIGHT_CTRL,//    = $9D;

    ('',''),//KEY_NONAME_9Eh,
    ('',''),//KEY_NONAME_9Fh,

    ('',''),//KEY_NONAME_A0h,
    ('',''),//KEY_NONAME_A1h,
    ('',''),//KEY_NONAME_A2h,
    ('',''),//KEY_NONAME_A3h,
    ('',''),//KEY_NONAME_A4h,
    ('',''),//KEY_NONAME_A5h,
    ('',''),//KEY_NONAME_A6h,
    ('',''),//KEY_NONAME_A7h,
    ('',''),//KEY_NONAME_A8h,
    ('',''),//KEY_NONAME_A9h,
    ('',''),//KEY_NONAME_AAh,
    ('',''),//KEY_NONAME_ABh,
    ('',''),//KEY_NONAME_ACh,
    ('',''),//KEY_NONAME_ADh,
    ('',''),//KEY_NONAME_AEh,
    ('',''),//KEY_NONAME_AFh,

    ('',''),//KEY_NONAME_B0h,
    ('',''),//KEY_NONAME_B1h,
    ('',''),//KEY_NONAME_B2h,
    ('',''),//KEY_NONAME_B3h,
    ('',''),//KEY_NONAME_B4h,

    ('/ на кейпаде','Keypad /'),//KEY_KP_DIVIDE,//     = $B5;

    ('',''),//KEY_NONAME_B6h,

    ('','Print Screen/SysRq'),//KEY_SYSRQ,//         = $B7;
    ('Правый Alt','Right Alt'),//KEY_RIGHT_ALT,//     = $B8;

    ('',''),//KEY_NONAME_B9h,
    ('',''),//KEY_NONAME_BAh,
    ('',''),//KEY_NONAME_BBh,
    ('',''),//KEY_NONAME_BCh,
    ('',''),//KEY_NONAME_BDh,
    ('',''),//KEY_NONAME_BEh,
    ('',''),//KEY_NONAME_BFh,

    ('',''),//KEY_NONAME_C0h,
    ('',''),//KEY_NONAME_C1h,
    ('',''),//KEY_NONAME_C2h,
    ('',''),//KEY_NONAME_C3h,
    ('',''),//KEY_NONAME_C4h,

    ('','Num Lock'),//KEY_NUM_LOCK,//      = $C5;

    ('',''),//KEY_NONAME_C6h,

    ('','Home'),//KEY_HOME,//          = $C7;
    ('Стрелка вверх','Up Arrow'),//KEY_UP,//            = $C8;
    ('','Page Up'),//KEY_PGUP,//          = $C9;

    ('',''),//KEY_NONAME_CAh,

    ('Стрелка влево','Left Arrow'),//KEY_LEFT,//          = $CB;

    ('',''),//KEY_NONAME_CCh,

    ('Стрелка вправо','Right Arrow'),//KEY_RIGHT,//         = $CD;

    ('',''),//KEY_NONAME_CEh,

    ('','End'),//KEY_END,//           = $CF;
    ('Стрелка вниз','Down Arrow'),//KEY_DOWN,//          = $D0;
    ('','Page Down'),//KEY_PGDN,//          = $D1;
    ('','Insert'),//KEY_INSERT,//        = $D2;
    ('','Delete'),//KEY_DELETE,//        = $D3;

    ('',''),//KEY_NONAME_D4h,
    ('',''),//KEY_NONAME_D5h,
    ('',''),//KEY_NONAME_D6h,
    ('',''),//KEY_NONAME_D7h,
    ('',''),//KEY_NONAME_D8h,
    ('',''),//KEY_NONAME_D9h,
    ('',''),//KEY_NONAME_DAh,

    ('Левая Windows','Left Windows'),//KEY_LEFT_WINDOWS,//  = $DB;
    ('Правая Windows','Right Windows'),//KEY_RIGHT_WINDOWS,// = $DC;
    ('Контекстное меню','Application menu'),//KEY_APP_MENU,//      = $DD;
    ('Питание','Power'),//KEY_POWER,//         = $DE;
    ('Спящий режим','Sleep'),//KEY_SLEEP,//         = $DF;

    ('',''),//KEY_NONAME_E0h,
    ('',''),//KEY_NONAME_E1h,
    ('',''),//KEY_NONAME_E2h,

    ('Пробуждение','Wake'),//KEY_WAKE,//          = $E3;

    ('',''),//KEY_NONAME_E4h,
    ('',''),//KEY_NONAME_E5h,
    ('',''),//KEY_NONAME_E6h,
    ('',''),//KEY_NONAME_E7h,
    ('',''),//KEY_NONAME_E8h,
    ('',''),//KEY_NONAME_E9h,

    ('Левый курок геймпада','Controller Left Trigger'),//KEY_GAMEPAD_LEFT_TRIGGER, //KEY_NONAME_EAh,
    ('Правый курок геймпада','Controller Right Trigger'),//KEY_GAMEPAD_RIGHT_TRIGGER, //KEY_NONAME_EBh,
    ('Стрелка вверх на геймпаде','Controller Up'),// KEY_GAMEPAD_DPAD_UP, //     KEY_NONAME_ECh,
    ('Стрелка вниз на геймпаде','Controller Down'),// KEY_GAMEPAD_DPAD_DOWN, //      KEY_NONAME_EDh,
    ('Стрелка влево на геймпаде','Controller Left'),// KEY_GAMEPAD_DPAD_LEFT, //       KEY_NONAME_EEh,
    ('Стрелка вправо на геймпаде','Controller Right'),// KEY_GAMEPAD_DPAD_RIGHT, //       KEY_NONAME_EFh,
    ('Start на геймпаде','Controller Start'),// KEY_GAMEPAD_START, //        KEY_NONAME_F0h,
    ('Back на геймпаде','Controller Back'),// KEY_GAMEPAD_BACK, //       KEY_NONAME_F1h,
    ('Левый джойстик геймпада','Controller Left Thumb'),// KEY_GAMEPAD_LEFT_THUMB, //        KEY_NONAME_F2h,
    ('Правый джойстик геймпада','Controller Right Thumb'),// KEY_GAMEPAD_RIGHT_THUMB, //         KEY_NONAME_F3h,
    ('Левое плечо геймпада','Controller Left Shoulder'),// KEY_GAMEPAD_LEFT_SHOULDER, //       KEY_NONAME_F4h,
    ('Правое плечо геймпада','Controller Right Shoulder'),// KEY_GAMEPAD_RIGHT_SHOULDER, //       KEY_NONAME_F5h,
    ('A на геймпаде','Controller A'),// KEY_GAMEPAD_A, //        KEY_NONAME_F6h,
    ('B на геймпаде','Controller B'),// KEY_GAMEPAD_B, //        KEY_NONAME_F7h,
    ('X на геймпаде','Controller X'),// KEY_GAMEPAD_X, //       KEY_NONAME_F8h,
    ('Y на геймпаде','Controller Y'),// KEY_GAMEPAD_Y, //       KEY_NONAME_F9h,

    ('Движение пера','Tablet pen action'), //KEY_TABLET_PEN_ACTION

    ('Колёсико мыши вниз','Mouse Wheel Down'),//KEY_MWHEEL_DOWN,//   = $FB;
    ('Колёсико мыши вверх','Mouse Wheel Up'),//KEY_MWHEEL_UP,//     = $FC;
    ('Средняя кнопка мыши','Middle Mouse Button'),//KEY_MOUSE_MIDDLE,//  = $FD;
    ('Правая кнопка мыши','Right Mouse Button'),//KEY_MOUSE_RIGHT,//   = $FE;
    ('Левая кнопка мыши','Left Mmouse Button')//KEY_MOUSE_LEFT//    = $FF;
);


